/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;

public class ActiveSessionListener
implements HttpSessionListener {
    private static Map<String, ActiveSession> _activeSessions = new HashMap<String, ActiveSession>();

    public void sessionCreated(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        _activeSessions.put(session.getId(), new ActiveSession(session.getId(), session, new Exception()));
        this._logSessionEvent("session.created", session);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        _activeSessions.remove(session.getId());
        this._logSessionEvent("session.destroyed", session);
    }

    private void _logSessionEvent(String eventId, HttpSession session) {
        ForensicLogger.info(eventId, ActiveSessionListener._transformSessionToJson(session), null);
    }

    public static Map<String, Object> getActiveSessions() {
        return _activeSessions.values().stream().collect(Collectors.toMap(ActiveSession::id, ActiveSessionListener::_transformSessionToMap));
    }

    private static Map<String, Object> _transformSessionToMap(ActiveSession activeSession) {
        HttpSession session = activeSession.session();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", session.getId());
        map.put("creation", session.getCreationTime());
        map.put("lastAccess", session.getLastAccessedTime());
        map.put("user", session.getAttribute("Runtime:UserIdentity"));
        map.put("exception", activeSession.creationStackTrace());
        return map;
    }

    public static List<Map<String, Object>> getActiveSessionsAsJson() {
        List<Map> a = _activeSessions.values().stream().map(ActiveSession::session).map(ActiveSessionListener::_transformSessionToJson).toList();
        return a.isEmpty() ? List.of() : a;
    }

    private static Map<String, Object> _transformSessionToJson(HttpSession session) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", session.getId());
        map.put("creation", ActiveSessionListener._convertMillisToReadableDate(session.getCreationTime()));
        map.put("lastAccess", ActiveSessionListener._convertMillisToReadableDate(session.getLastAccessedTime()));
        UserIdentity user = (UserIdentity)session.getAttribute("Runtime:UserIdentity");
        if (user != null) {
            map.put("user", UserIdentity.userIdentityToString(user));
        } else {
            Iterator it = session.getAttributeNames().asIterator();
            while (it.hasNext()) {
                String attributeName = (String)it.next();
                if (!attributeName.startsWith("Runtime:UserIdentity-")) continue;
                user = (UserIdentity)session.getAttribute(attributeName);
                if (user == null) break;
                map.put("user", UserIdentity.userIdentityToString(user) + " (" + attributeName.substring("Runtime:UserIdentity".length() + 1) + ")");
                break;
            }
        }
        return map;
    }

    private static String _convertMillisToReadableDate(long time) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withZone(ZoneId.systemDefault());
        Instant instant = Instant.ofEpochMilli(time);
        return formatter.format(instant);
    }

    public record ActiveSession(String id, HttpSession session, Exception creationStackTrace) {
    }
}

