/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus;

import com.jsoftbiz.utils.OS;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Date;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.plugins.admin.statistics.KernelStatisticsProvider;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GeneralStatusGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        RuntimeMXBean rBean = ManagementFactory.getRuntimeMXBean();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"characteristics");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"osTime", (String)DateUtils.dateToString(new Date()));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"osName", (String)OS.OS.getPlatformName());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"osVersion", (String)OS.OS.getVersion());
        String osPatch = System.getProperty("sun.os.patch.level");
        if (StringUtils.isNotEmpty((CharSequence)osPatch)) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"osPatch", (String)osPatch);
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"availableProc", (String)String.valueOf(osBean.getAvailableProcessors()));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"architecture", (String)OS.OS.getArch());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"javaVendor", (String)System.getProperty("java.vendor"));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"javaVersion", (String)System.getProperty("java.version"));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"jvmName", (String)rBean.getVmName());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"startTime", (String)DateUtils.dateToString(new Date(rBean.getStartTime())));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"tomcatVersion", (String)KernelStatisticsProvider.getTomcatVersion());
        String instanceId = "<?>";
        try {
            instanceId = RuntimeServlet.getInstanceId();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"ametysInstanceId", (String)instanceId);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"ametysHome", (String)RuntimeConfig.getInstance().getAmetysHome().getPath());
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"characteristics");
        this.contentHandler.endDocument();
    }
}

