/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugins.admin.jvmstatus.ActiveSessionListener;
import org.ametys.runtime.plugins.admin.jvmstatus.RequestCountListener;
import org.ametys.runtime.plugins.admin.jvmstatus.SessionCountListener;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringConstants;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringExtensionPoint;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.SampleManager;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AlertSampleManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdDb;

public class JVMStatusHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
MonitoringConstants {
    private MonitoringExtensionPoint _monitoringExtensionPoint;
    private I18nUtils _i18nUtils;
    private String _rrdStoragePath;

    public void service(ServiceManager manager) throws ServiceException {
        this._monitoringExtensionPoint = (MonitoringExtensionPoint)manager.lookup(MonitoringExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public void initialize() throws Exception {
        this._rrdStoragePath = FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"monitoring"}).getPath();
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> garbageCollect() {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Administrator is garbage collecting");
        }
        System.gc();
        return Collections.EMPTY_MAP;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getGeneralStatus() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("osTime", DateUtils.dateToString(new Date()));
        try {
            result.put("activeSessions", SessionCountListener.getSessionCount());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            result.put("activeSessionsDetail", ActiveSessionListener.getActiveSessionsAsJson());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            result.put("activeRequests", RequestCountListener.getCurrentRequestCount());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ThreadMXBean tBean = ManagementFactory.getThreadMXBean();
        MemoryMXBean mBean = ManagementFactory.getMemoryMXBean();
        RuntimeMXBean rBean = ManagementFactory.getRuntimeMXBean();
        result.put("activeThreads", tBean.getThreadCount());
        long[] lockedThreads = ManagementFactory.getThreadMXBean().findMonitorDeadlockedThreads();
        result.put("deadlockThreads", lockedThreads != null ? String.valueOf(lockedThreads.length) : "0");
        result.put("heap-memory-max", mBean.getHeapMemoryUsage().getMax());
        result.put("heap-memory-used", mBean.getHeapMemoryUsage().getUsed());
        result.put("heap-memory-commited", mBean.getHeapMemoryUsage().getCommitted());
        result.put("startTime", DateUtils.dateToString(new Date(rBean.getStartTime())));
        return result;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getMonitoringData() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap samples = new HashMap();
        ArrayList<String> periods = new ArrayList<String>();
        for (MonitoringConstants.Period period : MonitoringConstants.Period.values()) {
            periods.add(period.toString());
        }
        samples.put("periods", periods);
        ArrayList sampleList = new ArrayList();
        for (String extensionId : this._monitoringExtensionPoint.getExtensionsIds()) {
            HashMap<String, Object> sample = new HashMap<String, Object>();
            SampleManager sampleManager = (SampleManager)this._monitoringExtensionPoint.getExtension(extensionId);
            sample.put("id", sampleManager.getId());
            sample.put("label", this._i18nUtils.translate(sampleManager.getLabel()));
            sample.put("description", this._i18nUtils.translate(sampleManager.getDescription()));
            if (sampleManager instanceof AlertSampleManager && Config.getInstance().getValue("runtime.system.alerts.enable") == Boolean.TRUE) {
                HashMap<String, Object> thresholdValues = new HashMap<String, Object>();
                Map<String, AlertSampleManager.Threshold> thresholds = ((AlertSampleManager)sampleManager).getThresholdValues();
                for (String datasourceName : thresholds.keySet()) {
                    thresholdValues.put(datasourceName, thresholds.get(datasourceName).getValue());
                }
                sample.put("thresholds", thresholdValues);
            }
            File rrdFile = new File(this._rrdStoragePath, sampleManager.getId() + ".rrd");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using RRD file: " + String.valueOf(rrdFile));
            }
            try (RrdDb rrdDb = RrdDb.of((String)rrdFile.getPath());){
                sample.put("ds", rrdDb.getDsNames());
                HashSet<String> consolidationFunction = new HashSet<String>();
                for (int i = 0; i < rrdDb.getArcCount(); ++i) {
                    Archive archive = rrdDb.getArchive(i);
                    consolidationFunction.add(archive.getConsolFun().toString());
                }
                sample.put("consolFun", consolidationFunction);
            }
            catch (Exception e) {
                this.getLogger().error("Unable to collect sample for: " + sampleManager.getId(), (Throwable)e);
            }
            sampleList.add(sample);
        }
        samples.put("sampleList", sampleList);
        result.put("samples", samples);
        return result;
    }
}

