/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCountListener
implements ServletRequestListener {
    private static AtomicInteger _current = new AtomicInteger();
    private static AtomicInteger _total = new AtomicInteger();
    private static boolean _active;
    private static Logger _logger;

    public RequestCountListener() {
        _active = true;
    }

    public void requestInitialized(ServletRequestEvent event) {
        _current.incrementAndGet();
        _total.incrementAndGet();
    }

    public void requestDestroyed(ServletRequestEvent event) {
        _current.decrementAndGet();
    }

    public static int getCurrentRequestCount() {
        if (!_active) {
            String message = "The RequestCountListener is not installed. Please add in the file 'WEB-INF/web.xml' the following line under the root element :\n&lt;listener&gt;&lt;listener-class&gt;" + RequestCountListener.class.getName() + "&lt;/listener-class&gt;&lt;/listener&gt;";
            if (_logger == null) {
                _logger = LoggerFactory.getLogger(RequestCountListener.class);
            }
            if (_logger.isWarnEnabled()) {
                _logger.warn(message);
            }
            throw new IllegalStateException(message);
        }
        return _current.intValue();
    }

    public static int getTotalRequestCount() {
        if (!_active) {
            String message = "The RequestCountListener is not installed. Please add in the file 'WEB-INF/web.xml' the following line under the root element :\n&lt;listener&gt;&lt;listener-class&gt;" + RequestCountListener.class.getName() + "&lt;/listener-class&gt;&lt;/listener&gt;";
            if (_logger == null) {
                _logger = LoggerFactory.getLogger(RequestCountListener.class);
            }
            if (_logger.isWarnEnabled()) {
                _logger.warn(message);
            }
            throw new IllegalStateException(message);
        }
        return _total.intValue();
    }
}

