/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCountListener
implements HttpSessionListener {
    private static AtomicInteger _count = new AtomicInteger();
    private static boolean _active;
    private static Logger _logger;

    public SessionCountListener() {
        _active = true;
    }

    public void sessionCreated(HttpSessionEvent se) {
        _active = true;
        _count.incrementAndGet();
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        _active = true;
        if (!_count.compareAndSet(0, 0)) {
            _count.decrementAndGet();
        }
    }

    public static int getSessionCount() {
        if (!_active) {
            String message = "The SessionCountListener is not installed. Please add in the file 'WEB-INF/web.xml' the following line under the root element :\n&lt;listener&gt;&lt;listener-class&gt;" + SessionCountListener.class.getName() + "&lt;/listener-class&gt;&lt;/listener&gt;";
            if (_logger == null) {
                _logger = LoggerFactory.getLogger(SessionCountListener.class);
            }
            if (_logger.isWarnEnabled()) {
                _logger.warn(message);
            }
            throw new IllegalStateException(message);
        }
        return _count.intValue();
    }
}

