/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadMXBean;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.DateUtils;
import org.apache.avalon.framework.component.Component;

public class ThreadInfo
implements Component {
    public static final String ROLE = ThreadInfo.class.getName();
    private Pattern _groupPattern = Pattern.compile("^(.*)-\\d+$");

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/admin")
    public Map<String, Object> getThreadDump() {
        StringBuffer threadDump = new StringBuffer(System.lineSeparator());
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (java.lang.management.ThreadInfo threadInfo : threadMXBean.dumpAllThreads(true, true)) {
            threadDump.append(this._threadInfoToString(threadInfo));
        }
        return Map.of("date", DateUtils.zonedDateTimeToString(ZonedDateTime.now()), "data", threadDump.toString().replaceAll("\r", ""));
    }

    @Callable(rights={"REPOSITORY_Rights_Access"}, context="/admin")
    public List<Map<String, Object>> dumpAllThreads() {
        java.lang.management.ThreadInfo[] threads;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (java.lang.management.ThreadInfo thread : threads = threadMXBean.dumpAllThreads(true, true)) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            String name = thread.getThreadName();
            String group = "-";
            Matcher matcher = this._groupPattern.matcher(name);
            if (matcher.matches()) {
                group = matcher.group(1);
            }
            info.put("name", name);
            info.put("group", group);
            info.put("state", (Object)thread.getThreadState());
            info.put("cpu", threadMXBean.getThreadCpuTime(thread.getThreadId()));
            info.put("blocked-time", thread.getBlockedTime());
            info.put("waited-time", thread.getWaitedTime());
            info.put("lock-owner", thread.getLockOwnerName());
            String trace = Arrays.stream(thread.getStackTrace()).map(el -> this._printStackTraceElement((StackTraceElement)el)).collect(Collectors.joining("\n"));
            info.put("stack-trace", trace);
            info.put("stack-ametys", Arrays.stream(thread.getStackTrace()).anyMatch(el -> el.getClassName().contains("org.ametys")));
            info.put("stack-size", thread.getStackTrace().length);
            result.add(info);
        }
        return result;
    }

    private String _printStackTraceElement(StackTraceElement el) {
        return el.getClassName() + "." + el.getMethodName() + "(" + (String)(el.isNativeMethod() ? "Native Method)" : (el.getFileName() != null && el.getLineNumber() >= 0 ? el.getFileName() + ":" + el.getLineNumber() + ")" : (el.getFileName() != null ? el.getFileName() + ")" : "Unknown Source)")));
    }

    private String _threadInfoToString(java.lang.management.ThreadInfo threadInfo) {
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\"" + (threadInfo.isDaemon() ? " daemon" : "") + " prio=" + threadInfo.getPriority() + " Id=" + threadInfo.getThreadId() + " " + String.valueOf((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            sb.append(" on " + threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"" + threadInfo.getLockOwnerName() + "\" Id=" + threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + String.valueOf(threadInfo.getLockInfo()));
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + String.valueOf(threadInfo.getLockInfo()));
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + String.valueOf(threadInfo.getLockInfo()));
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + String.valueOf(lockInfo));
                sb.append('\n');
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + String.valueOf(lockInfo));
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

