/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringConstants;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.io.FileUtils;
import org.rrd4j.core.Archive;
import org.rrd4j.core.RrdDb;

public class GetRRdDataAction
extends ServiceableAction
implements Initializable,
MonitoringConstants {
    private String _rrdStoragePath;

    public void initialize() throws Exception {
        this._rrdStoragePath = FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"monitoring"}).getPath();
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String sampleId = parameters.getParameter("sampleId");
        File rrdFile = new File(this._rrdStoragePath, sampleId + ".rrd");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using RRD file: " + String.valueOf(rrdFile));
        }
        if (!rrdFile.exists()) {
            throw new ProcessingException("None sample manager exists for: " + sampleId);
        }
        TreeMap<Long, Map<String, Object>> data = new TreeMap<Long, Map<String, Object>>();
        try (RrdDb rrdDb = RrdDb.of((String)rrdFile.getPath());){
            for (Archive archive : this._getRelevantArchives(rrdDb)) {
                long archiveStartTime = archive.getStartTime();
                for (int row = 0; row < archive.getRows(); ++row) {
                    Map<CallSite, Double> values;
                    long time = (archiveStartTime + (long)row * archive.getArcStep()) * 1000L;
                    if (data.containsKey(time)) {
                        values = (Map)data.get(time);
                    } else {
                        values = new HashMap();
                        data.put(time, values);
                    }
                    String[] dsNames = rrdDb.getDsNames();
                    for (int dsIndex = 0; dsIndex < rrdDb.getDsCount(); ++dsIndex) {
                        String dsName = archive.getConsolFun().toString() + "_" + dsNames[dsIndex];
                        double value = archive.getRobin(dsIndex).getValue(row);
                        if (values.containsKey(dsName)) continue;
                        if (Double.isNaN(value)) {
                            value = 0.0;
                        }
                        values.put((CallSite)((Object)dsName), value);
                    }
                }
            }
        }
        List<Map<String, Object>> result = this._convertData(data);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private List<Archive> _getRelevantArchives(RrdDb rrdDb) {
        ArrayList<Archive> result = new ArrayList<Archive>();
        for (int i = 0; i < rrdDb.getArcCount(); ++i) {
            Archive archive = rrdDb.getArchive(i);
            result.add(archive);
        }
        return result;
    }

    private List<Map<String, Object>> _convertData(SortedMap<Long, Map<String, Object>> data) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Long time : data.keySet()) {
            Map row = (Map)data.get(time);
            row.put("time", time);
            result.add(row);
        }
        return result;
    }
}

