/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring;

import java.io.File;
import java.io.IOException;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringConstants;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.SampleManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.commons.io.FileUtils;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

public class MonitoringExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<SampleManager>
implements MonitoringConstants {
    public static final String ROLE = MonitoringExtensionPoint.class.getName();

    @Override
    public void initializeExtensions() throws Exception {
        super.initializeExtensions();
        File rrdStorageDir = FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"monitoring"});
        if (!rrdStorageDir.exists() && !rrdStorageDir.mkdirs()) {
            throw new Exception("Unable to create monitoring directory: " + String.valueOf(rrdStorageDir));
        }
        for (String extensionId : this.getExtensionsIds()) {
            SampleManager sampleManager = (SampleManager)this.getExtension(extensionId);
            String sampleName = sampleManager.getId();
            File rrdFile = new File(rrdStorageDir, sampleName + ".rrd");
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Creating RRD file: " + String.valueOf(rrdFile));
            }
            if (rrdFile.exists()) continue;
            RrdDef rrdDef = new RrdDef(rrdFile.getPath(), 60L);
            sampleManager.configureRRDDef(rrdDef);
            try {
                RrdDb rrdDb = RrdDb.of((RrdDef)rrdDef);
                if (rrdDb == null) continue;
                rrdDb.close();
            }
            catch (IOException e) {
                throw new Exception("Unable to create RRD file: " + String.valueOf(rrdFile));
            }
        }
    }
}

