/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring;

import jakarta.mail.MessagingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringConstants;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.MonitoringExtensionPoint;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.SampleManager;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AlertSampleManager;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.rrd4j.core.RrdDb;

public class RRDsFeederSchedulable
extends AbstractStaticSchedulable
implements Initializable,
MonitoringConstants {
    private static final String __CONFIG_ALERTS_ENABLED = "runtime.system.alerts.enable";
    private static final String __CONFIG_FROM_MAIL = "smtp.mail.from";
    private static final String __CONFIG_ADMIN_MAIL = "smtp.mail.sysadminto";
    private MonitoringExtensionPoint _monitoringExtensionPoint;
    private String _rrdStoragePath;
    private I18nUtils _i18nUtils;
    private Map<String, Map<String, Boolean>> _currentAlerts;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._monitoringExtensionPoint = (MonitoringExtensionPoint)manager.lookup(MonitoringExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public void initialize() throws Exception {
        this._rrdStoragePath = FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"monitoring"}).getPath();
        this._currentAlerts = new LinkedHashMap<String, Map<String, Boolean>>();
    }

    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Time to collect data");
        }
        for (String extensionId : this._monitoringExtensionPoint.getExtensionsIds()) {
            SampleManager sampleManager = (SampleManager)this._monitoringExtensionPoint.getExtension(extensionId);
            if (sampleManager == null) continue;
            String sampleName = sampleManager.getId();
            File rrdFile = new File(this._rrdStoragePath, sampleName + ".rrd");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Collecting sample for: " + sampleName);
            }
            try {
                RrdDb rrdDb = RrdDb.of((String)rrdFile.getPath());
                try {
                    Map<String, Object> collectedValues = sampleManager.collect(rrdDb.createSample());
                    if (!(sampleManager instanceof AlertSampleManager)) continue;
                    this._checkIfAlert((AlertSampleManager)sampleManager, collectedValues);
                }
                finally {
                    if (rrdDb == null) continue;
                    rrdDb.close();
                }
            }
            catch (Exception e) {
                this.getLogger().error("Unable to collect sample for: " + sampleName, (Throwable)e);
            }
        }
    }

    private void _checkIfAlert(AlertSampleManager sampleManager, Map<String, Object> collectedValues) {
        if (Config.getInstance() == null) {
            return;
        }
        if (Config.getInstance().getValue(__CONFIG_ALERTS_ENABLED, true, false).booleanValue()) {
            if (this._currentAlerts.get(sampleManager.getId()) == null) {
                this._currentAlerts.put(sampleManager.getId(), new HashMap());
            }
            String language = this._userLanguagesManager.getDefaultLanguage();
            Map<String, AlertSampleManager.Threshold> thresholds = sampleManager.getThresholdValues();
            for (String datasourceName : thresholds.keySet()) {
                AlertSampleManager.Threshold threshold;
                if (this._currentAlerts.get(sampleManager.getId()).get(datasourceName) == null) {
                    this._currentAlerts.get(sampleManager.getId()).put(datasourceName, false);
                }
                if ((threshold = thresholds.get(datasourceName)).isExceeded(collectedValues.get(datasourceName)) && !this._currentAlerts.get(sampleManager.getId()).get(datasourceName).booleanValue()) {
                    this._sendAlertMail(threshold.getMailSubject(), threshold.getMailBody(), collectedValues.get(datasourceName).toString(), threshold.getValue().toString(), language);
                    this._currentAlerts.get(sampleManager.getId()).put(datasourceName, true);
                    continue;
                }
                if (threshold.isExceeded(collectedValues.get(datasourceName)) || !this._currentAlerts.get(sampleManager.getId()).get(datasourceName).booleanValue()) continue;
                this._currentAlerts.get(sampleManager.getId()).put(datasourceName, false);
            }
        }
    }

    private void _sendAlertMail(I18nizableText subject, I18nizableText body, String currentValue, String thresholdValue, String language) {
        block2: {
            Config config = Config.getInstance();
            String fromMail = (String)config.getValue(__CONFIG_FROM_MAIL);
            String toMail = (String)StringUtils.defaultIfBlank((CharSequence)((String)config.getValue(__CONFIG_ADMIN_MAIL)), (CharSequence)fromMail);
            try {
                String subjectStr = this._i18nUtils.translate(subject, language);
                ArrayList<String> bodyParams = new ArrayList<String>();
                bodyParams.add(currentValue);
                bodyParams.add(thresholdValue);
                I18nizableText bodyWithParams = body.isI18n() ? new I18nizableText(body.getCatalogue(), body.getKey(), bodyParams) : body;
                String htmlBody = StandardMailBodyHelper.newHTMLBody().withTitle(subject).withMessage(bodyWithParams).withLanguage(language).build();
                SendMailHelper.newMail().withSubject(subjectStr).withHTMLBody(htmlBody).withRecipient(toMail).withSender(fromMail).sendMail();
            }
            catch (MessagingException | IOException e) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("Could not send an alert e-mail to " + toMail, e);
            }
        }
    }
}

