/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.AbstractSampleManager;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

public abstract class AbstractMemorySampleManager
extends AbstractSampleManager {
    @Override
    protected void _configureDatasources(RrdDef rrdDef) {
        rrdDef.addDatasource("commited", DsType.GAUGE, 120L, 0.0, Double.NaN);
        rrdDef.addDatasource("used", DsType.GAUGE, 120L, 0.0, Double.NaN);
        rrdDef.addDatasource("max", DsType.GAUGE, 120L, 0.0, Double.NaN);
    }

    @Override
    protected Map<String, Object> _internalCollect(Sample sample) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = this._getMemoryUsage(memoryMXBean);
        long commited = memoryUsage.getCommitted();
        sample.setValue("commited", (double)commited);
        result.put("commited", commited);
        long used = memoryUsage.getUsed();
        sample.setValue("used", (double)used);
        result.put("used", used);
        long max = memoryUsage.getMax();
        sample.setValue("max", (double)max);
        result.put("max", max);
        return result;
    }

    protected abstract MemoryUsage _getMemoryUsage(MemoryMXBean var1);
}

