/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.AbstractSampleManager;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

public class CPUSampleManager
extends AbstractSampleManager {
    private static MXBeanCPUMonitor _mxBeanCPUMonitor;

    @Override
    protected void _configureDatasources(RrdDef rrdDef) {
        this._registerDatasources(rrdDef, "current", DsType.GAUGE, 0.0, Double.NaN);
    }

    @Override
    protected Map<String, Object> _internalCollect(Sample sample) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (_mxBeanCPUMonitor == null) {
            _mxBeanCPUMonitor = new MXBeanCPUMonitor(this);
        }
        double cpuUsage = _mxBeanCPUMonitor.getCpuUsage();
        sample.setValue("current", cpuUsage);
        result.put("current", cpuUsage);
        return result;
    }

    @Override
    protected String _getGraphTitle() {
        return "CPU use";
    }

    public class MXBeanCPUMonitor {
        private int _availableProcessors = this.getOperatingSystemMXBean().getAvailableProcessors();
        private long _lastProcessCpuTime;
        private long _lastSystemTime;

        MXBeanCPUMonitor(CPUSampleManager this$0) {
        }

        private void baselineCounters() {
            this._lastSystemTime = System.nanoTime();
            if (this.getOperatingSystemMXBean() != null) {
                this._lastProcessCpuTime = this.getOperatingSystemMXBean().getProcessCpuTime();
            }
        }

        private OperatingSystemMXBean getOperatingSystemMXBean() {
            java.lang.management.OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
            if (bean instanceof OperatingSystemMXBean) {
                return (OperatingSystemMXBean)bean;
            }
            return null;
        }

        public synchronized double getCpuUsage() {
            if (this._lastSystemTime == 0L) {
                this.baselineCounters();
                return 0.0;
            }
            long systemTime = System.nanoTime();
            long processCpuTime = 0L;
            if (this.getOperatingSystemMXBean() == null) {
                return 0.0;
            }
            processCpuTime = this.getOperatingSystemMXBean().getProcessCpuTime();
            double cpuUsage = (double)(processCpuTime - this._lastProcessCpuTime) / (double)(systemTime - this._lastSystemTime);
            this._lastSystemTime = systemTime;
            this._lastProcessCpuTime = processCpuTime;
            return cpuUsage / (double)this._availableProcessors * 100.0;
        }
    }
}

