/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.AbstractSampleManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

public class CacheSampleManager
extends AbstractSampleManager
implements Serviceable {
    private AbstractCacheManager _cacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    @Override
    protected void _configureDatasources(RrdDef rrdDef) {
        this._registerDatasources(rrdDef, "total", DsType.GAUGE, 0.0, Double.NaN);
    }

    @Override
    protected Map<String, Object> _internalCollect(Sample sample) throws IOException {
        try {
            long sum = this._cacheManager.getAllCaches().values().stream().flatMap(Collection::stream).filter(Cache::isComputableSize).mapToLong(Cache::getMemorySize).sum();
            float value = (float)sum / 1048576.0f;
            sample.setValue("total", (double)value);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("total", Float.valueOf(value));
            return result;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String _getGraphTitle() {
        return "Cache";
    }
}

