/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.DiskSpaceHelper;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AbstractAlertSampleManager;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AlertSampleManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

public class DiskSpaceSampleManager
extends AbstractAlertSampleManager
implements Serviceable {
    private DiskSpaceHelper _diskSpaceHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._diskSpaceHelper = (DiskSpaceHelper)manager.lookup(DiskSpaceHelper.ROLE);
    }

    @Override
    protected void _configureDatasources(RrdDef rrdDef) {
        this._registerDatasources(rrdDef, "free", DsType.GAUGE, 0.0, Double.NaN);
    }

    @Override
    protected Map<String, Object> _internalCollect(Sample sample) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        long free = this._diskSpaceHelper.getAvailableSpace() / 1024L / 1024L;
        sample.setValue("free", (double)free);
        result.put("free", free);
        return result;
    }

    @Override
    protected String _getGraphTitle() {
        return "Free space on disk";
    }

    @Override
    protected Map<String, String> getThresholdConfigNames() {
        return Collections.singletonMap("free", "runtime.system.alerts.diskspace.threshold");
    }

    @Override
    protected Map<String, AlertSampleManager.Threshold.Operator> getOperators() {
        return Collections.singletonMap("free", AlertSampleManager.Threshold.Operator.LEQ);
    }
}

