/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AbstractAlertSampleManager;
import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.alerts.AlertSampleManager;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

public class ThreadSampleManager
extends AbstractAlertSampleManager {
    @Override
    protected void _configureDatasources(RrdDef rrdDef) {
        this._registerDatasources(rrdDef, "daemon", DsType.GAUGE, 0.0, Double.NaN);
        this._registerDatasources(rrdDef, "total", DsType.GAUGE, 0.0, Double.NaN);
    }

    @Override
    protected Map<String, Object> _internalCollect(Sample sample) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int daemon = threadMXBean.getDaemonThreadCount();
        sample.setValue("daemon", (double)daemon);
        result.put("daemon", daemon);
        int total = threadMXBean.getThreadCount();
        sample.setValue("total", (double)total);
        result.put("total", total);
        return result;
    }

    @Override
    protected String _getGraphTitle() {
        return "Live thread";
    }

    @Override
    protected Map<String, String> getThresholdConfigNames() {
        return Collections.singletonMap("total", "runtime.system.alerts.threads.threshold");
    }

    @Override
    protected Map<String, AlertSampleManager.Threshold.Operator> getOperators() {
        return Collections.singletonMap("total", AlertSampleManager.Threshold.Operator.GEQ);
    }
}

