/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.logs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.excalibur.source.ModifiableSource;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;

public class LogsClientSideElement
extends StaticClientSideElement {
    private static final String __LOGS_BASE = "ametys-home://logs/";
    private SourceResolver _sourceResolver;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> deleteLogs(List<String> files) throws ProcessingException, IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> failures = new ArrayList<String>();
        ArrayList<String> successes = new ArrayList<String>();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Administrator starts a deletion of " + files.size() + " logged file");
        }
        for (String location : files) {
            if (this._deleteFile(location)) {
                successes.add(location);
                continue;
            }
            failures.add(location);
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Process terminated with following results : failure '" + ((Object)failures).toString() + " successes '" + ((Object)successes).toString());
        }
        result.put("failures", failures);
        result.put("successes", successes);
        return result;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> purgeLogs() throws ProcessingException {
        GregorianCalendar purgeCalendar = new GregorianCalendar();
        ((Calendar)purgeCalendar).add(5, -12);
        Date purgeDate = new Date(purgeCalendar.getTimeInMillis());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting purge...");
            this.getLogger().debug("Purge date is " + String.valueOf(purgeDate));
        }
        ArrayList<String> filesList = new ArrayList<String>();
        TraversableSource logsSources = null;
        try {
            logsSources = (TraversableSource)this._sourceResolver.resolveURI(__LOGS_BASE);
            for (Object log : logsSources.getChildren()) {
                ModifiableTraversableSource logSource = (ModifiableTraversableSource)log;
                if (logSource.isCollection() || !logSource.getURI().endsWith(".log") && !logSource.getURI().endsWith(".log.gz") || logSource.getName().startsWith("forensic-") || !new Date(logSource.getLastModified()).before(purgeDate)) continue;
                String location = logSource.getURI();
                String name = location.substring(location.lastIndexOf(47) + 1);
                filesList.add(name);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Adding file to purge : " + name);
            }
            Map<String, Object> map = this.deleteLogs(filesList);
            return map;
        }
        catch (SourceException e) {
            String message = "The purge of old log files failed";
            this.getLogger().error(message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
        catch (IOException e) {
            String message = "The log directory was not found";
            this.getLogger().error(message, (Throwable)e);
            throw new ProcessingException(message, (Throwable)e);
        }
        finally {
            if (logsSources != null) {
                this._sourceResolver.release((Source)logsSources);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _deleteFile(String fileLocation) throws IOException, ProcessingException {
        boolean bl;
        block11: {
            ModifiableSource logsource;
            block9: {
                boolean bl2;
                block10: {
                    if (fileLocation.indexOf("/") != -1 || fileLocation.indexOf(92) != -1) {
                        String message = "The LogsDeleteAction has been call with the forbiden parameter '" + fileLocation + "'";
                        this.getLogger().error(message);
                        throw new ProcessingException(message);
                    }
                    logsource = null;
                    if (!fileLocation.endsWith(".log")) break block9;
                    logsource = (ModifiableSource)this._sourceResolver.resolveURI(__LOGS_BASE + fileLocation);
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Removing log file " + logsource.getURI());
                    }
                    logsource.delete();
                    bl2 = true;
                    if (logsource == null) break block10;
                    this._sourceResolver.release((Source)logsource);
                }
                return bl2;
            }
            try {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Ignoring this file during deletion '' because it does not ends with .log");
                }
                bl = false;
                if (logsource == null) break block11;
            }
            catch (SourceException e) {
                boolean bl3;
                block12: {
                    try {
                        this.getLogger().error("The administrator tried unsuccessfully to remove the following log file '" + (logsource != null ? logsource.getURI() : fileLocation) + "'.", (Throwable)e);
                        bl3 = false;
                        if (logsource == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (logsource != null) {
                            this._sourceResolver.release(logsource);
                        }
                        throw throwable;
                    }
                    this._sourceResolver.release((Source)logsource);
                }
                return bl3;
            }
            this._sourceResolver.release((Source)logsource);
        }
        return bl;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> changeLogLevel(String level, String category) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Administrator change log level");
        }
        LoggerRepository loggerRepository = LogManager.getLoggerRepository();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Log level changing category '" + category + "' " + level);
        }
        try {
            this._changeLogLevel(loggerRepository, category, level);
        }
        catch (Throwable t) {
            String errorMessage = "Cannot change log level correctly : changing category '" + category + "'";
            this.getLogger().error(errorMessage, t);
            result.put("error", "error");
            return result;
        }
        return result;
    }

    private void _changeLogLevel(LoggerRepository loggerRepository, String category, String mode) {
        Logger logger;
        boolean inherited = "INHERIT".equals(mode) || "INHERITFORCED".equals(mode);
        boolean force = "FORCE".equals(mode) || "INHERITFORCED".equals(mode);
        boolean isRoot = false;
        if ("root".equals(category)) {
            isRoot = true;
            logger = loggerRepository.getRootLogger();
        } else {
            logger = loggerRepository.getLogger(category);
        }
        if (inherited && !isRoot) {
            logger.setLevel(null);
        }
        if (force) {
            Enumeration e = loggerRepository.getCurrentLoggers();
            while (e.hasMoreElements()) {
                Logger l = (Logger)e.nextElement();
                if (l.getParent() != logger) continue;
                this._changeLogLevel(loggerRepository, l.getName(), "INHERITFORCED");
            }
        }
        if (!inherited && !force) {
            Level level = Level.toLevel((String)mode);
            logger.setLevel(level);
        }
    }
}

