/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.migration;

import java.time.Instant;
import java.util.Map;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.MigrationExtensionPoint;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.ActionExtensionPoint;
import org.ametys.core.migration.version.Version;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class MigrationsActionsClientSideElement
extends StaticClientSideElement {
    private MigrationEngine _migrationEngine;
    private MigrationExtensionPoint _migrationExtensionPoint;
    private MigrationExtensionPoint _migrationDataExtensionPoint;
    private ActionExtensionPoint _upgradeEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._migrationEngine = (MigrationEngine)manager.lookup(MigrationEngine.ROLE);
        this._migrationExtensionPoint = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE);
        this._migrationDataExtensionPoint = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE + "/internal");
        this._upgradeEP = (ActionExtensionPoint)manager.lookup(ActionExtensionPoint.ROLE_UPGRADE);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void acknowledge(String componentId, boolean internal, String versionListId, String versionNumber, String comment) throws MigrationException {
        MigrationEngine.MigrationComponent component = internal ? (MigrationEngine.MigrationComponent)this._migrationDataExtensionPoint.getExtension(componentId) : (MigrationEngine.MigrationComponent)this._migrationExtensionPoint.getExtension(componentId);
        MigrationEngine.VersionList versionList = this._getVersionList(component, versionListId);
        Version version = new Version(component, versionList.componentId(), component.versionStorage(), versionList.storageConfiguration(), versionNumber, Instant.now(), comment);
        component.versionStorage().storeVersion(version);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void deleteVersion(String componentId, boolean internal, String versionListId, String versionNumber) throws MigrationException {
        MigrationEngine.MigrationComponent component = internal ? (MigrationEngine.MigrationComponent)this._migrationDataExtensionPoint.getExtension(componentId) : (MigrationEngine.MigrationComponent)this._migrationExtensionPoint.getExtension(componentId);
        MigrationEngine.VersionList versionList = this._getVersionList(component, versionListId);
        component.versionStorage().removeVersion(versionList.componentId(), versionNumber, versionList.storageConfiguration());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void deleteAllVersions(String componentId, boolean internal, String versionListId) throws MigrationException {
        MigrationEngine.MigrationComponent component = internal ? (MigrationEngine.MigrationComponent)this._migrationDataExtensionPoint.getExtension(componentId) : (MigrationEngine.MigrationComponent)this._migrationExtensionPoint.getExtension(componentId);
        MigrationEngine.VersionList versionList = this._getVersionList(component, versionListId);
        component.versionStorage().removeAllVersions(versionList.componentId(), versionList.storageConfiguration());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public boolean doAction(String componentId, boolean internal, String versionListId, String upgradeNumber, boolean store, String comment) throws MigrationException {
        MigrationEngine.MigrationComponent component = internal ? (MigrationEngine.MigrationComponent)this._migrationDataExtensionPoint.getExtension(componentId) : (MigrationEngine.MigrationComponent)this._migrationExtensionPoint.getExtension(componentId);
        ActionConfiguration actionConfiguration = component.upgrades().stream().filter(ac -> ac.getVersionNumber().equals(upgradeNumber)).findFirst().orElseThrow(() -> new MigrationException("no such upgrade: " + upgradeNumber));
        MigrationEngine.VersionList versionList = this._getVersionList(component, versionListId);
        Version version = new Version(component, versionList.componentId(), component.versionStorage(), versionList.storageConfiguration(), null, null, null);
        if (versionList.additionalValues() != null) {
            for (Map.Entry<String, Object> entry : versionList.additionalValues().entrySet()) {
                version.addAdditionalValue(entry.getKey(), entry.getValue());
            }
        }
        boolean requiresRestart = this._migrationEngine.doAction(new MigrationEngine.ActionData(version, null, actionConfiguration, versionList.id()), this._upgradeEP);
        if (store) {
            component.versionStorage().removeVersion(versionList.componentId(), upgradeNumber, versionList.storageConfiguration());
            version.setComment(comment);
            version.setExecutionInstant(Instant.now());
            version.setVersionNumber(upgradeNumber);
            component.versionStorage().storeVersion(version);
        }
        return requiresRestart;
    }

    private MigrationEngine.VersionList _getVersionList(MigrationEngine.MigrationComponent component, String versionListId) throws MigrationException {
        MigrationEngine.Versions versions = this._migrationEngine.getVersions(component);
        MigrationEngine.VersionList versionList = this._migrationEngine.getVersionList(versions, versionListId);
        if (versionList == null) {
            throw new MigrationException("There's no version list for id: " + versionListId + " in component: " + String.valueOf(component));
        }
        return versionList;
    }
}

