/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.migration;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.MigrationExtensionPoint;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.version.Version;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class MigrationsStatus
implements Serviceable,
Component {
    private MigrationEngine _migrationEngine;
    private MigrationExtensionPoint _migrationExtensionPoint;
    private MigrationExtensionPoint _migrationInternalExtensionPoint;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._migrationEngine = (MigrationEngine)manager.lookup(MigrationEngine.ROLE);
        this._migrationExtensionPoint = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE);
        this._migrationInternalExtensionPoint = (MigrationExtensionPoint)manager.lookup(MigrationExtensionPoint.ROLE + "/internal");
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getMigrationsStatus(Map<String, Object> clientParameters) throws ConfigurationException, MigrationException {
        TreeMap<String, List<Map<String, Object>>> migrationsByPlugins = new TreeMap<String, List<Map<String, Object>>>();
        this._migrationsByPlugins(true, migrationsByPlugins, this._migrationInternalExtensionPoint);
        this._migrationsByPlugins(false, migrationsByPlugins, this._migrationExtensionPoint);
        List<Map<String, Object>> allNodes = migrationsByPlugins.entrySet().stream().map(entry -> this._plugin2json((String)entry.getKey(), (List)entry.getValue())).toList();
        ArrayList<Map<String, Object>> parentInfos = new ArrayList<Map<String, Object>>();
        return Map.of("children", this._filter(allNodes, Strings.CS.removeStart((String)clientParameters.get("path"), (CharSequence)"/root"), parentInfos), "parentInfos", parentInfos);
    }

    private List<Map<String, Object>> _filter(List<Map<String, Object>> allNodes, String path, List<Map<String, Object>> parentInfos) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return allNodes;
        }
        int i = path.indexOf(47, 1);
        i = i == -1 ? path.length() : i;
        String thisNode = path.substring(1, i);
        String subPath = path.substring(i);
        for (Map<String, Object> map : allNodes) {
            if (!thisNode.equals(map.get("component"))) continue;
            parentInfos.add(Map.of("failed", map.get("failed"), "warning", map.get("warning")));
            return this._filter((List)map.get("children"), subPath, parentInfos);
        }
        throw new IllegalArgumentException("Cannot find component '" + thisNode + "'");
    }

    private void _migrationsByPlugins(boolean isInternal, Map<String, List<Map<String, Object>>> migrationsByPlugins, MigrationExtensionPoint migrationExtensionPoint) {
        for (String extensionId : migrationExtensionPoint.getExtensionsIds()) {
            MigrationEngine.MigrationComponent component = (MigrationEngine.MigrationComponent)migrationExtensionPoint.getExtension(extensionId);
            List migrations = migrationsByPlugins.computeIfAbsent(component.pluginName(), k -> new ArrayList());
            try {
                String string;
                MigrationEngine.Versions versions = this._migrationEngine.getVersions(component);
                List<Map<String, Object>> children = this._versions2json(isInternal, extensionId, versions, component.upgrades());
                String string2 = component.versionHandlerType();
                String string3 = component.versionStorage().getId();
                if (versions instanceof MigrationEngine.VersionList) {
                    MigrationEngine.VersionList vl = (MigrationEngine.VersionList)versions;
                    string = vl.id();
                } else {
                    string = null;
                }
                migrations.add(this._component2json(isInternal, extensionId, extensionId, children, string2, string3, true, string));
            }
            catch (MigrationException e) {
                migrations.add(this._componentFailure2json(isInternal, extensionId, component.versionHandlerType(), component.versionStorage().getId(), e));
            }
        }
    }

    private List<Map<String, Object>> _versions2json(boolean isInternal, String componentId, MigrationEngine.Versions versions, List<ActionConfiguration> existingUpgrades) {
        if (versions instanceof MigrationEngine.VersionsContainer) {
            MigrationEngine.VersionsContainer versionsContainer = (MigrationEngine.VersionsContainer)versions;
            return this._versionContainer2json(isInternal, componentId, versionsContainer, existingUpgrades);
        }
        if (versions instanceof MigrationEngine.VersionList) {
            MigrationEngine.VersionList versionList = (MigrationEngine.VersionList)versions;
            return this._versionList2json(isInternal, componentId, versionList, existingUpgrades);
        }
        throw new IllegalArgumentException("Object " + String.valueOf(versions) + " is not supported");
    }

    private List<Map<String, Object>> _versionContainer2json(boolean isInternal, String componentId, MigrationEngine.VersionsContainer versionsContainer, List<ActionConfiguration> existingUpgrades) {
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : versionsContainer.entrySet()) {
            String string;
            MigrationEngine.Versions versions = (MigrationEngine.Versions)entry.getValue();
            List<Map<String, Object>> granChildren = this._versions2json(isInternal, componentId, versions, existingUpgrades);
            String string2 = this._i18nUtils.translate((I18nizable)entry.getKey());
            if (versions instanceof MigrationEngine.VersionList) {
                MigrationEngine.VersionList vl = (MigrationEngine.VersionList)versions;
                string = vl.id();
            } else {
                string = null;
            }
            children.add(this._component2json(isInternal, componentId, string2, granChildren, null, null, false, string));
        }
        Collections.sort(children, new TreeComparator(this));
        return children;
    }

    private List<Map<String, Object>> _versionList2json(boolean isInternal, String componentId, MigrationEngine.VersionList versionList, List<ActionConfiguration> existingUpgrades) {
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        Set existingUpgradeNumbers = existingUpgrades.stream().map(ActionConfiguration::getVersionNumber).collect(Collectors.toSet());
        TreeSet<String> done = new TreeSet<String>();
        Version latestVersion = this._migrationEngine.getLatestVersion(versionList.versions());
        for (Version version : versionList.versions()) {
            done.add(version.getVersionNumber());
            children.add(this._version2json(isInternal, componentId, versionList.id(), version, latestVersion == version, "0".equals(version.getVersionNumber()) || existingUpgradeNumbers.contains(version.getVersionNumber())));
        }
        if (this._isFailedAction(versionList.id()) && this._failedActionIsTheFutureCurrentVersion(existingUpgrades, done, latestVersion)) {
            done.add((String)StringUtils.defaultIfBlank((CharSequence)this._migrationEngine.getFailedAction().targetVersionNumber(), (CharSequence)this._migrationEngine.getFailedAction().configuration().getVersionNumber()));
            children.add(this._failureVersion2json(isInternal, componentId, versionList.id()));
        }
        for (ActionConfiguration actionConfiguration : existingUpgrades) {
            if (done.contains(actionConfiguration.getVersionNumber())) continue;
            children.add(this._pendingVersion2json(isInternal, componentId, versionList.id(), actionConfiguration, this._newest(done), this._oldest(done)));
        }
        Collections.sort(children, new TreeComparator(this));
        Collections.reverse(children);
        if (children.size() > 0 && !"0".equals(((Map)children.get(children.size() - 1)).get("component")) || children.size() == 0) {
            children.add(this._pendingVersion2json(isInternal, componentId, versionList.id(), null, this._newest(done), this._oldest(done)));
        }
        return children;
    }

    private boolean _failedActionIsTheFutureCurrentVersion(List<ActionConfiguration> existingUpgrades, Set<String> done, Version latestVersion) {
        TreeSet<String> pendingNumbers = new TreeSet<String>();
        for (ActionConfiguration actionConfiguration : existingUpgrades) {
            String versionToHandle = actionConfiguration.getVersionNumber();
            if (done.contains(versionToHandle) || latestVersion != null && latestVersion.getVersionNumber().compareTo(versionToHandle) >= 0) continue;
            pendingNumbers.add(versionToHandle);
        }
        return this._migrationEngine.getFailedAction().currentVersion().getVersionNumber() != null && Strings.CS.equals(this._oldest(pendingNumbers), this._migrationEngine.getFailedAction().configuration().getVersionNumber()) || this._migrationEngine.getFailedAction().currentVersion().getVersionNumber() == null && Strings.CS.equals((String)StringUtils.defaultIfBlank((CharSequence)this._newest(pendingNumbers), (CharSequence)"0"), (String)StringUtils.defaultIfBlank((CharSequence)this._migrationEngine.getFailedAction().targetVersionNumber(), (CharSequence)this._migrationEngine.getFailedAction().configuration().getVersionNumber()));
    }

    private Map<String, Object> _plugin2json(String pluginName, List<Map<String, Object>> children) {
        Collections.sort(children, new TreeComparator(this));
        return Map.of("component", pluginName, "expanded", true, "failed", this._any(children, "failed"), "warning", this._any(children, "warning"), "type", "plugin", "children", children);
    }

    private Map<String, Object> _component2json(boolean isInternal, String componentId, String componentLabel, List<Map<String, Object>> children, String versionHandlerType, String versionStorageType, boolean rootComponent, String versionListId) {
        return Map.of("component", componentLabel, "componentId", componentId, "comment", rootComponent ? "Type: " + versionHandlerType + (String)(Strings.CS.equals(versionHandlerType, versionStorageType) ? "" : "/" + versionStorageType) : "", "versionListId", StringUtils.defaultString((String)versionListId), "failed", this._any(children, "failed"), "warning", this._any(children, "warning"), "type", rootComponent ? "component" : "container", "internal", isInternal, "children", children);
    }

    private Map<String, Object> _componentFailure2json(boolean isInternal, String componentId, String versionHandlerType, String versionStorageType, MigrationException ex) {
        return Map.of("component", componentId, "comment", "Type: " + versionHandlerType + (String)(Strings.CS.equals(versionHandlerType, versionStorageType) ? "" : "/" + versionStorageType), "errorComment", this._migrationExceptionToCommentString(ex), "failed", true, "warning", false, "internal", isInternal, "type", "component");
    }

    private Map<String, Object> _pendingVersion2json(boolean isInternal, String componentId, String versionListId, ActionConfiguration actionConfiguration, String currentStoredVersion, String oldestStoredVersion) {
        String versionNumber = actionConfiguration != null ? actionConfiguration.getVersionNumber() : "0";
        boolean past = currentStoredVersion != null && versionNumber.compareTo(currentStoredVersion) < 0;
        boolean beforeInitPast = past && versionNumber.compareTo(oldestStoredVersion) < 0;
        return Map.of("component", versionNumber, "componentId", componentId, "versionListId", versionListId, "failed", false, "warning", false, "comment", actionConfiguration != null ? StringUtils.defaultString((String)actionConfiguration.getComment()) : "", "instant", "", "internal", isInternal, "type", past ? (beforeInitPast ? "past-before" : "past-notdone") : "pending");
    }

    private Map<String, Object> _failureVersion2json(boolean isInternal, String componentId, String versionListId) {
        return Map.of("component", StringUtils.defaultIfBlank((CharSequence)this._migrationEngine.getFailedAction().targetVersionNumber(), (CharSequence)this._migrationEngine.getFailedAction().configuration().getVersionNumber()), "componentId", componentId, "versionListId", versionListId, "failed", true, "warning", false, "comment", StringUtils.defaultString((String)this._migrationEngine.getFailedAction().configuration().getComment()), "errorComment", this._migrationExceptionToCommentString(this._migrationEngine.getFailedException()), "instant", DateUtils.zonedDateTimeToString(ZonedDateTime.ofInstant(this._migrationEngine.getFailedAction().currentVersion().getExecutionInstant(), ZoneOffset.UTC)), "internal", isInternal, "type", "error");
    }

    private Map<String, Object> _version2json(boolean isInternal, String componentId, String versionListId, Version version, boolean current, boolean existing) {
        return Map.of("component", StringUtils.defaultString((String)version.getVersionNumber()), "componentId", componentId, "versionListId", versionListId, "comment", StringUtils.defaultString((String)version.getComment()), "errorComment", !existing ? this._i18nUtils.translate(new I18nizableText("plugin.admin", "PLUGINS_ADMIN_TOOL_MIGRATIONS_COL_COMMENT_NONEXISTING")) : "", "failed", false, "warning", !existing, "instant", version.getExecutionInstant() != null ? DateUtils.zonedDateTimeToString(ZonedDateTime.ofInstant(version.getExecutionInstant(), ZoneOffset.UTC)) : "", "internal", isInternal, "type", current ? "current" : "past-done");
    }

    private String _newest(Set<String> s) {
        return s.size() > 0 ? (String)s.stream().skip(s.size() - 1).findFirst().orElse(null) : null;
    }

    private String _oldest(Set<String> s) {
        return s.stream().findFirst().orElse(null);
    }

    private boolean _isFailedAction(String versionListId) {
        return this._migrationEngine.getFailedAction() != null && Strings.CS.equals(versionListId, this._migrationEngine.getFailedAction().versionListId());
    }

    private String _migrationExceptionToCommentString(MigrationException ex) {
        return ex != null ? ex.getFailureMessage().replaceAll("<", "&lt;").replaceAll("\n", "<br/>") : "";
    }

    private boolean _any(List<Map<String, Object>> children, String key) {
        for (Map<String, Object> child : children) {
            List granChildren;
            if (child.get(key) == Boolean.TRUE) {
                return true;
            }
            Object object = child.get("children");
            if (!(object instanceof List) || !this._any(granChildren = (List)object, key)) continue;
            return true;
        }
        return false;
    }

    private final class TreeComparator
    implements Comparator<Map> {
        private TreeComparator(MigrationsStatus migrationsStatus) {
        }

        @Override
        public int compare(Map o1, Map o2) {
            return ((String)o1.get("component")).toLowerCase().compareTo(((String)o2.get("component")).toLowerCase());
        }
    }
}

