/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.plugins.doc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginDocGenerator
extends ServiceableGenerator {
    private SourceResolver _sourceResolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"plugins");
        Set<String> pluginNames = PluginsManager.getInstance().getPluginNames();
        for (String pluginName : pluginNames) {
            this._saxPlugin(pluginName);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"plugins");
        this.contentHandler.endDocument();
    }

    private void _saxPlugin(String pluginName) throws IOException, SAXException, ProcessingException {
        Source pluginSource = this._sourceResolver.resolveURI("plugin:" + pluginName + "://plugin.xml");
        SAXParser saxParser = null;
        try (InputStream is = pluginSource.getInputStream();){
            saxParser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
            saxParser.parse(new InputSource(is), (ContentHandler)((Object)new SpecialHandler(this, this.contentHandler, pluginName)));
        }
        catch (ServiceException e) {
            throw new ProcessingException("Unable to get a SAX parser", (Throwable)e);
        }
        finally {
            this._sourceResolver.release(pluginSource);
            this.manager.release((Object)saxParser);
        }
    }

    public class SpecialHandler
    extends IgnoreRootHandler {
        private String _pluginName;
        private int _level;

        public SpecialHandler(PluginDocGenerator this$0, ContentHandler handler, String pluginName) {
            super(handler);
            this._pluginName = pluginName;
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            ++this._level;
            if (this._level == 1) {
                AttributesImpl attr = new AttributesImpl(a);
                attr.addCDATAAttribute("name", this._pluginName);
                super.startElement(uri, loc, raw, (Attributes)attr);
            } else {
                super.startElement(uri, loc, raw, a);
            }
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            --this._level;
            super.endElement(uri, loc, raw);
        }
    }
}

