/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.rights;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.Strings;

public class AdminAccessController
implements AccessController,
Serviceable,
PluginAware {
    public static final String ADMIN_RIGHT_CONTEXT = "/admin";
    protected RightsExtensionPoint _rightsExtensionPoint;
    protected UserManager _userManager;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._rightsExtensionPoint = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    @Override
    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if (user != null && Strings.CS.equals(user.getPopulationId(), "admin_population")) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    @Override
    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return this.getPermission(user, userGroups, null, object);
    }

    @Override
    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        if (user != null && Strings.CS.equals(user.getPopulationId(), "admin_population")) {
            return this._rightsExtensionPoint.getExtensionsIds().stream().collect(Collectors.toMap(rightId -> rightId, rightId -> AccessController.AccessResult.USER_ALLOWED));
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    @Override
    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    @Override
    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    @Override
    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    @Override
    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        return this._userManager.getUsers("admin_population").stream().collect(Collectors.toMap(user -> user.getIdentity(), user -> AccessController.AccessResult.USER_ALLOWED));
    }

    @Override
    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return this.getPermissionByUser(null, object);
    }

    @Override
    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return this.hasUserAnyPermissionOnWorkspace(workspacesContexts, user, userGroups, null);
    }

    @Override
    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return workspacesContexts.contains(ADMIN_RIGHT_CONTEXT) && Strings.CS.equals(user.getPopulationId(), "admin_population");
    }

    @Override
    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    @Override
    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    @Override
    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    @Override
    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    @Override
    public boolean supports(Object object) {
        if (object instanceof String) {
            String context = (String)object;
            return ADMIN_RIGHT_CONTEXT.equals(context) || context.startsWith("/admin/");
        }
        return false;
    }

    @Override
    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> explainAllPermissions(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        return Map.of();
    }

    @Override
    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnonymous(Object object) {
        return Map.of();
    }

    @Override
    public Map<AccessController.Permission, AccessExplanation> explainAllPermissionsForAnyConnected(Object object) {
        return Map.of();
    }

    @Override
    public Map<UserIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByUser(Object object) {
        return Map.of();
    }

    @Override
    public Map<GroupIdentity, Map<AccessController.Permission, AccessExplanation>> explainAllPermissionsByGroup(Object object) {
        return Map.of();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getObjectLabel(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public I18nizableText getObjectCategory(Object object) {
        throw new UnsupportedOperationException();
    }
}

