/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.statistics;

import com.jsoftbiz.utils.OS;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.CredentialProviderFactory;
import org.ametys.core.authentication.CredentialProviderModel;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.GroupDirectoryFactory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.directory.UserDirectoryFactory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.version.VersionsHandler;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsNode;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;
import org.ametys.runtime.servlet.AnalyseFileForVirusHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelStatisticsProvider
implements StatisticsProvider,
Serviceable,
PluginAware {
    private static String _tomcatVersion;
    private static Logger _logger;
    private String _id;
    private VersionsHandler _versionsHandler;
    private UserPopulationDAO _userPopulationDAO;
    private UserDirectoryFactory _userDirectoryFactory;
    private CredentialProviderFactory _credentialProviderFactory;
    private GroupDirectoryDAO _groupDirectoryDAO;
    private GroupDirectoryFactory _groupDirectoryFactory;

    public void service(ServiceManager manager) throws ServiceException {
        this._versionsHandler = (VersionsHandler)manager.lookup(VersionsHandler.ROLE);
        this._userPopulationDAO = (UserPopulationDAO)manager.lookup(UserPopulationDAO.ROLE);
        this._userDirectoryFactory = (UserDirectoryFactory)manager.lookup(UserDirectoryFactory.ROLE);
        this._credentialProviderFactory = (CredentialProviderFactory)manager.lookup(CredentialProviderFactory.ROLE);
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._groupDirectoryFactory = (GroupDirectoryFactory)manager.lookup(GroupDirectoryFactory.ROLE);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public static synchronized String getTomcatVersion() {
        if (_tomcatVersion == null) {
            try {
                Class<?> tomcatServerInfo = KernelStatisticsProvider.class.getClassLoader().loadClass("org.apache.catalina.util.ServerInfo");
                _tomcatVersion = (String)tomcatServerInfo.getMethod("getServerNumber", new Class[0]).invoke(tomcatServerInfo, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                _logger.warn("Cannot get the tomcat version", (Throwable)e);
            }
        }
        return _tomcatVersion;
    }

    @Override
    public Statistics getStatistics() {
        return new StatisticsNode(this._id, new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_LABEL"), "ametysicon-trademark-ametys", null, List.of(this._getVersionsStatistics(), this._getPluginsStatistics(), this._getConfigurationStatistics(), this._getPopulationsAndGropDirectoriesStatistics(), this._getServerStatistics()), true);
    }

    private Statistics _getServerStatistics() {
        return new StatisticsNode("server", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_LABEL"), "ametysicon-system-server-sync", null, List.of(new StatisticsValue("osname", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_OS_LABEL"), "ametysicon-system-terminal", OS.OS.getPlatformName() + " (" + OS.OS.getVersion() + ")"), new StatisticsValue("cpu", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_CPU_LABEL"), "ametysicon-trademark-jackrabbit", String.valueOf(ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors()) + " x " + OS.OS.getArch()), new StatisticsValue("ram", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_RAM_LABEL"), "ametysicon-system-sgbd", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax()), new StatisticsValue("vmvendor", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_VMVENDOR_LABEL"), "ametysicon-trademark-jstack", System.getProperty("java.vendor") + " " + ManagementFactory.getRuntimeMXBean().getVmName()), new StatisticsValue("vmversion", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_VMVERSION_LABEL"), "ametysicon-trademark-jstack", System.getProperty("java.version")), new StatisticsValue("tomcatversion", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_TOMCATVERSION_LABEL"), "ametysicon-trademark-tomcat", KernelStatisticsProvider.getTomcatVersion())), false);
    }

    private Statistics _getVersionsStatistics() {
        return new StatisticsNode("versions", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_VERSIONS_LABEL"), "ametysicon-maths-number-zero-one", null, this._getVersionsChildren(), true);
    }

    private List<Statistics> _getVersionsChildren() {
        return this._versionsHandler.getVersions().stream().map(v -> new StatisticsValue(v.getName(), new I18nizableText(v.getName()), "ametysicon-trademark-ametys", v.getVersion())).map(Statistics.class::cast).toList();
    }

    private Statistics _getPluginsStatistics() {
        List<Statistics> plugins = PluginsManager.getInstance().getBundledPluginsNames().stream().sorted(Comparator.naturalOrder()).map(pluginName -> new StatisticsValue((String)pluginName, new I18nizableText((String)pluginName), "ametysicon-puzzle-piece1", PluginsManager.getInstance().getVersion((String)pluginName))).map(Statistics.class::cast).toList();
        return new StatisticsNode("plugins", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_PLUGINS_LABEL"), "ametysicon-puzzle-piece1", null, plugins, false);
    }

    private Statistics _getPopulationsAndGropDirectoriesStatistics() {
        long populations = 0L;
        TreeMap<String, Long> userDirectoriesCount = new TreeMap<String, Long>();
        TreeMap<String, Long> credentialProvidersCount = new TreeMap<String, Long>();
        for (UserPopulation userPopulation : this._userPopulationDAO.getUserPopulations(false)) {
            Long value;
            ++populations;
            for (UserDirectory userDirectory : userPopulation.getUserDirectories()) {
                value = userDirectoriesCount.getOrDefault(userDirectory.getUserDirectoryModelId(), 0L);
                userDirectoriesCount.put(userDirectory.getUserDirectoryModelId(), value + 1L);
            }
            for (CredentialProvider credentialProvider : userPopulation.getCredentialProviders()) {
                value = credentialProvidersCount.getOrDefault(credentialProvider.getCredentialProviderModelId(), 0L);
                credentialProvidersCount.put(credentialProvider.getCredentialProviderModelId(), value + 1L);
            }
        }
        ArrayList<Statistics> userDirectories = new ArrayList<Statistics>();
        for (Map.Entry entry : userDirectoriesCount.entrySet()) {
            userDirectories.add(new StatisticsValue((String)entry.getKey(), this._userDirectoryFactory.getExtension((String)entry.getKey()).getLabel(), "ametysicon-body-idcard-white", entry.getValue()));
        }
        ArrayList<Statistics> arrayList = new ArrayList<Statistics>();
        for (Map.Entry entry : credentialProvidersCount.entrySet()) {
            CredentialProviderModel cp = this._credentialProviderFactory.getExtension((String)entry.getKey());
            arrayList.add(new StatisticsValue((String)entry.getKey(), cp.getLabel(), (String)StringUtils.defaultIfBlank((CharSequence)cp.getIconGlyph(), (CharSequence)"ametysicon-body-idcard-badge"), entry.getValue()));
        }
        long l = 0L;
        TreeMap<String, Long> groupDirectoriesCount = new TreeMap<String, Long>();
        for (GroupDirectory groupDirectory : this._groupDirectoryDAO.getGroupDirectories()) {
            ++l;
            Long value = groupDirectoriesCount.getOrDefault(groupDirectory.getGroupDirectoryModelId(), 0L);
            groupDirectoriesCount.put(groupDirectory.getGroupDirectoryModelId(), value + 1L);
        }
        ArrayList<Statistics> groupDirectories = new ArrayList<Statistics>();
        for (Map.Entry entry : groupDirectoriesCount.entrySet()) {
            groupDirectories.add(new StatisticsValue((String)entry.getKey(), this._groupDirectoryFactory.getExtension((String)entry.getKey()).getLabel(), "ametysicon-body-people", entry.getValue()));
        }
        return new StatisticsNode("populations-groupdirectories", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_USERPOPULATIONSANDGROUPDIRECTORIES_LABEL"), "ametysicon-body-group", populations + l, List.of(new StatisticsNode("populations", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_USERPOPULATIONSANDGROUPDIRECTORIES_POPULATIONS_LABEL"), "ametysicon-body-people", populations, List.of(new StatisticsNode("userdirectories", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_USERPOPULATIONSANDGROUPDIRECTORIES_POPULATIONS_USERDIRECTORIES_LABEL"), "ametysicon-body-idcard-white", null, userDirectories, false), new StatisticsNode("credentialproviders", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_USERPOPULATIONSANDGROUPDIRECTORIES_POPULATIONS_CREDENTIALPROVIDERS_LABEL"), "ametysicon-body-idcard-badge", null, arrayList, false)), false), new StatisticsNode("groupdirectories", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_USERPOPULATIONSANDGROUPDIRECTORIES_GROUPDIRECTORIES_LABEL"), "ametysicon-body-people", l, groupDirectories, false)), false);
    }

    private StatisticsNode _getConfigurationStatistics() {
        boolean configProd = Config.getInstance().getValue("runtime.mode.dev", false, true) == false;
        String configCaptchaType = Config.getInstance().getValue("runtime.captcha.type", false, "");
        Long configMaxUpload = Config.getInstance().getValue("runtime.upload.max-size", false, 0L);
        boolean configGravatar = Config.getInstance().getValue("runtime.userprofile.imagesource.gravatar", false, true);
        return new StatisticsNode("config", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_CONFIG_LABEL"), "ametysicon-gear39", null, List.of(new StatisticsValue("production", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_CONFIG_PRODUCTION_LABEL"), "ametysicon-movie16", configProd), new StatisticsValue("captcha", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_CONFIG_CAPTCHA_LABEL"), "ametysicon-abecedary4", configCaptchaType), new StatisticsValue("upload", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_CONFIG_UPLOAD_LABEL"), "ametysicon-arrow-up-from", configMaxUpload), new StatisticsValue("gravatar", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_CONFIG_GRAVATAR_LABEL"), "ametysicon-body-idcard-black", configGravatar), new StatisticsValue("antivirus", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_KERNEL_SERVER_ANTIVIRUS_LABEL"), "ametysicon-arrow-down-in", AnalyseFileForVirusHelper.isAntivirusEnabled())), false);
    }

    static {
        _logger = LoggerFactory.getLogger((String)KernelStatisticsProvider.class.getName());
    }
}

