/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.statistics;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsValue;

public class StatisticsNode
extends StatisticsValue {
    private List<Statistics> _children;
    private boolean _expanded;

    public StatisticsNode(String name, I18nizableText label, String icon, Object value, List<Statistics> children, boolean expanded) {
        super(name, label, icon, value);
        this._children = children;
        this._expanded = expanded;
    }

    public List<Statistics> getChildren() {
        return this._children;
    }

    @Override
    public Map<String, Object> toJSONForExport() {
        LinkedHashMap<String, Object> children = new LinkedHashMap<String, Object>();
        for (Statistics statistics : this._children) {
            children.putAll(statistics.toJSONForExport());
        }
        children.put("_value", this.getValue());
        return Map.of(this.getName(), children);
    }

    @Override
    public Map<String, Object> toJSONTree() {
        Map<String, Object> jsonTree = super.toJSONTree();
        jsonTree.put("leaf", false);
        jsonTree.put("expanded", this._expanded);
        jsonTree.put("children", this._children.stream().map(Statistics::toJSONTree).toList());
        return jsonTree;
    }
}

