/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.statistics;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.JSONUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugins.admin.statistics.Statistics;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProvider;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class StatisticsProviderExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<StatisticsProvider> {
    public static final String ROLE = StatisticsProviderExtensionPoint.class.getName();
    static final String _I18N_PREFIX = "{{i18n ";
    static final String _I18N_SEPARATOR = ":";
    static final String _I18N_SUFFIX = "}}";
    private static final String FILE = "administrator" + File.separator + "statistics.json";
    private JSONUtils _jsonUtils;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public Map<String, Object> computeStatistics() throws IOException {
        HashMap<String, Object> jsonStatistics = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> treeStatistics = new ArrayList<Map<String, Object>>();
        for (String extensionId : this.getExtensionsIds()) {
            StatisticsProvider extension = (StatisticsProvider)this.getExtension(extensionId);
            Statistics extensionStatistics = extension.getStatistics();
            jsonStatistics.putAll(extensionStatistics.toJSONForExport());
            treeStatistics.add(extensionStatistics.toJSONTree());
        }
        Path file = AmetysHomeHelper.getAmetysHome().toPath().resolve(FILE);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
            this._jsonUtils.convertObjectToJson(os, treeStatistics);
        }
        return jsonStatistics;
    }

    @Callable(context="/admin", rights={"Runtime_Rights_Admin_Access"})
    public Object getStatisticsTree() throws IOException {
        Path file = AmetysHomeHelper.getAmetysHome().toPath().resolve(FILE);
        if (Files.exists(file, new LinkOption[0])) {
            String json = Files.readString(file, StandardCharsets.UTF_8);
            List<Object> tree = this._jsonUtils.convertJsonToList(json);
            this._handleI18n(tree);
            if (tree.size() > 0) {
                return tree;
            }
        }
        return Map.of("children", List.of(Map.of("name", "error", "label", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_TOOL_EMPTY"), "value", new I18nizableText("plugin.admin", "PLUGINS_ADMIN_STATISTICS_TOOL_EMPTY2"), "iconCls", "ametysicon-sign-caution", "leaf", true)));
    }

    private void _handleI18n(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            for (Object node : list) {
                this._handleI18n(node);
            }
        } else if (object instanceof Map) {
            String string;
            Map map = (Map)object;
            Object label = map.get("label");
            if (label instanceof String && (string = (String)label).startsWith(_I18N_PREFIX) && string.endsWith(_I18N_SUFFIX)) {
                String[] i18n = string.substring(_I18N_PREFIX.length(), string.length() - _I18N_SUFFIX.length()).trim().split(_I18N_SEPARATOR);
                I18nizableText i18nizableText = new I18nizableText(i18n[0], i18n[1]);
                map.put("label", i18nizableText);
            }
            Object children = map.get("children");
            this._handleI18n(children);
        }
    }
}

