/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.statistics;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugins.admin.statistics.StatisticsProviderExtensionPoint;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.io.CloseMode;
import org.quartz.JobExecutionContext;

public class StatisticsSchedulable
extends AbstractStaticSchedulable
implements Initializable,
Disposable {
    private static final String CENTRAL_SERVER_URL = "https://statistics.ametys.org/_update-version/statistics/1.0.0/upload.json";
    private static final String CENTRAL_SERVER_HEADER = "X-Ametys-Statistics";
    private JSONUtils _jsonUtils;
    private StatisticsProviderExtensionPoint _statisticsExtensionPoint;
    private CloseableHttpClient _httpClient;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._statisticsExtensionPoint = (StatisticsProviderExtensionPoint)manager.lookup(StatisticsProviderExtensionPoint.ROLE);
    }

    public void initialize() throws Exception {
        this._httpClient = HttpUtils.createHttpClient(0, 30);
    }

    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        this.getLogger().info("Preparing statistics");
        Map<String, Object> jsonStatistics = this._statisticsExtensionPoint.computeStatistics();
        if (Config.getInstance().getValue("runtime.statistics.send-at-night", false, false).booleanValue()) {
            this.getLogger().info("Sending remote statistics");
            this._sendReport(jsonStatistics);
        }
    }

    private void _sendReport(Map<String, Object> report) {
        try {
            HttpPost request = new HttpPost(CENTRAL_SERVER_URL);
            request.addHeader(CENTRAL_SERVER_HEADER, (Object)RuntimeServlet.getInstanceId());
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(Set.of(new BasicNameValuePair("value", this._jsonUtils.convertObjectToJson(report))), StandardCharsets.UTF_8));
            this._httpClient.execute((ClassicHttpRequest)request, response -> {
                if (response.getCode() != 200) {
                    throw new IllegalStateException("Could not join the central ametys.org server at https://statistics.ametys.org/_update-version/statistics/1.0.0/upload.json. Error code " + response.getCode());
                }
                if (!response.containsHeader(CENTRAL_SERVER_HEADER)) {
                    throw new IllegalStateException("Could not join the central ametys.org server at https://statistics.ametys.org/_update-version/statistics/1.0.0/upload.json. Response code is 200, but there is not X-Ametys-Statistics header");
                }
                try {
                    Boolean b;
                    String responseAsString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                    Map<String, Object> convertJsonToMap = this._jsonUtils.convertJsonToMap(responseAsString);
                    Object patt0$temp = convertJsonToMap.get("success");
                    if (!(patt0$temp instanceof Boolean) || (b = (Boolean)patt0$temp) != Boolean.TRUE) {
                        throw new IllegalStateException("Joined the central ametys.org server at https://statistics.ametys.org/_update-version/statistics/1.0.0/upload.json. But the operation failed.");
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Joined the central ametys.org server at https://statistics.ametys.org/_update-version/statistics/1.0.0/upload.json. But cannot parse the response.", e);
                }
                return true;
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not join the central ametys.org server at https://statistics.ametys.org/_update-version/statistics/1.0.0/upload.json", e);
        }
    }

    public void dispose() {
        this._httpClient.close(CloseMode.GRACEFUL);
    }
}

