/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.statistics;

import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugins.admin.statistics.Statistics;

public class StatisticsValue
implements Statistics {
    private Object _value;
    private String _name;
    private I18nizableText _label;
    private String _icon;

    public StatisticsValue(String name, I18nizableText label, String icon, Object value) {
        this._name = name;
        this._label = label;
        this._icon = icon;
        this._value = value;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public String getIcon() {
        return this._icon;
    }

    public Object getValue() {
        return this._value;
    }

    @Override
    public Map<String, Object> toJSONForExport() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(this._name, this._value);
        return m;
    }

    @Override
    public Map<String, Object> toJSONTree() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", this._name);
        m.put("label", this._label.isI18n() ? "{{i18n " + this._label.getCatalogue() + ":" + this._label.getKey() + "}}" : this._label.getLabel());
        m.put("iconCls", this._icon);
        m.put("value", this._value);
        m.put("leaf", true);
        return m;
    }
}

