/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.system;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.runtime.servlet.RuntimeServlet;

public class MaintenanceClientSideElement
extends StaticClientSideElement {
    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        List<ClientSideElement.Script> scripts = super.getScripts(ignoreRights, contextParameters);
        ArrayList<ClientSideElement.Script> modifiedScripts = new ArrayList<ClientSideElement.Script>();
        block4: for (ClientSideElement.Script script : scripts) {
            ClientSideElement.Script modifiedScript = new ClientSideElement.Script(script);
            modifiedScripts.add(modifiedScript);
            switch (RuntimeServlet.getMaintenanceStatus()) {
                case AUTOMATIC: {
                    modifiedScript.getParameters().put("toggle-state", "true");
                    modifiedScript.getParameters().put("disabled", "true");
                    modifiedScript.getParameters().put("description", modifiedScript.getParameters().get("automatic-description"));
                    modifiedScript.getParameters().put("icon-decorator", modifiedScript.getParameters().get("on-icon-decorator"));
                    modifiedScript.getParameters().put("icon-decorator-type", modifiedScript.getParameters().get("on-icon-decorator-type"));
                    continue block4;
                }
                case FORCED: {
                    modifiedScript.getParameters().put("toggle-state", "true");
                    modifiedScript.getParameters().put("disabled", "false");
                    modifiedScript.getParameters().put("description", modifiedScript.getParameters().get("forced-on-description"));
                    modifiedScript.getParameters().put("icon-decorator", modifiedScript.getParameters().get("on-icon-decorator"));
                    modifiedScript.getParameters().put("icon-decorator-type", modifiedScript.getParameters().get("on-icon-decorator-type"));
                    continue block4;
                }
            }
            modifiedScript.getParameters().put("toggle-state", "false");
            modifiedScript.getParameters().put("disabled", "false");
            modifiedScript.getParameters().put("description", modifiedScript.getParameters().get("forced-off-description"));
            modifiedScript.getParameters().put("icon-decorator", modifiedScript.getParameters().get("off-icon-decorator"));
            modifiedScript.getParameters().put("icon-decorator-type", modifiedScript.getParameters().get("off-icon-decorator-type"));
        }
        return modifiedScripts;
    }

    @Callable(context="/admin", rights={"Runtime_Rights_Admin_Maintenance_Activate"})
    public void goToNormalMode() {
        if (RuntimeServlet.getRunMode() == RuntimeServlet.RunMode.MAINTENANCE && RuntimeServlet.getMaintenanceStatus() == RuntimeServlet.MaintenanceStatus.FORCED) {
            RuntimeServlet.setMaintenanceStatus(RuntimeServlet.MaintenanceStatus.NONE, null);
            RuntimeServlet.setRunMode(RuntimeServlet.RunMode.NORMAL);
        }
    }

    @Callable(context="/admin", rights={"Runtime_Rights_Admin_Maintenance_Activate"})
    public void goToMaintenanceMode(String comment) {
        if (RuntimeServlet.getRunMode() == RuntimeServlet.RunMode.NORMAL) {
            RuntimeServlet.setMaintenanceStatus(RuntimeServlet.MaintenanceStatus.FORCED, new RuntimeServlet.ForcedMainteanceInformations(comment, this._currentUserProvider.getUser(), ZonedDateTime.now()));
            RuntimeServlet.setRunMode(RuntimeServlet.RunMode.MAINTENANCE);
        }
    }
}

