/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.system;

import java.time.ZonedDateTime;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class MaintenanceSchedulable
extends AbstractStaticSchedulable {
    public static final String JOBDATAMAP_MODE = "mode";
    public static final String JOBDATAMAP_COMMENT = "comment";

    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        boolean mode = jobDataMap.getBoolean("parameterValues#mode");
        String comment = StringUtils.defaultString((String)jobDataMap.getString("parameterValues#comment"));
        UserIdentity userIdentity = UserIdentity.stringToUserIdentity(jobDataMap.getString("userIdentity"));
        if (mode) {
            this.getLogger().info("Entering maintenance mode");
            if (RuntimeServlet.getRunMode() != RuntimeServlet.RunMode.NORMAL) {
                throw new IllegalStateException("Cannot enter the maintenance mode because the current mode is " + String.valueOf((Object)RuntimeServlet.getRunMode()));
            }
            RuntimeServlet.setMaintenanceStatus(RuntimeServlet.MaintenanceStatus.FORCED, new RuntimeServlet.ForcedMainteanceInformations(comment, userIdentity, ZonedDateTime.now()));
            RuntimeServlet.setRunMode(RuntimeServlet.RunMode.MAINTENANCE);
        } else {
            this.getLogger().info("Leaving maintenance mode");
            if (RuntimeServlet.getRunMode() != RuntimeServlet.RunMode.MAINTENANCE || RuntimeServlet.getMaintenanceStatus() == RuntimeServlet.MaintenanceStatus.AUTOMATIC) {
                throw new IllegalStateException("Cannot leave the maintenance mode because the current mode is " + String.valueOf((Object)RuntimeServlet.getRunMode()) + " and maintenance status " + String.valueOf((Object)RuntimeServlet.getMaintenanceStatus()));
            }
            RuntimeServlet.setMaintenanceStatus(RuntimeServlet.MaintenanceStatus.NONE, null);
            RuntimeServlet.setRunMode(RuntimeServlet.RunMode.NORMAL);
        }
    }
}

