/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.plugins.admin.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SystemHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
Initializable {
    public static final String ADMINISTRATOR_SYSTEM_FILENAME = "system.xml";
    public static final String ROLE = SystemHelper.class.getName();
    private static final String SYSTEM_ANNOUNCEMENT_CACHE = SystemHelper.class.getName() + "$SystemAnnouncement";
    private static final String SYSTEM_ANNOUNCEMENT_CACHE_KEY = SystemHelper.class.getName() + "$SystemAnnouncement";
    private org.ametys.core.util.I18nUtils _i18nUtils;
    private Context _context;
    private AbstractCacheManager _cacheManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._i18nUtils = (org.ametys.core.util.I18nUtils)((Object)serviceManager.lookup(org.ametys.core.util.I18nUtils.ROLE));
        this._cacheManager = (AbstractCacheManager)serviceManager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(SYSTEM_ANNOUNCEMENT_CACHE, new I18nizableText("plugin.admin", "PLUGINS_ADMIN_CACHE_SYSTEM_ANNOUNCEMENT_LABEL"), new I18nizableText("plugin.admin", "PLUGINS_ADMIN_CACHE_SYSTEM_ANNOUNCEMENT_DESCRIPTION"), true, null);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void setAnnouncementAvailable(boolean available) throws ProcessingException {
        SystemAnnouncement systemAnnouncement = this.readValues();
        this._save(available ? "on" : "off", null, null, systemAnnouncement.getMessages());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void scheduleAnnouncement(String startDateStr, String endDateStr) throws ProcessingException {
        ZonedDateTime startDate = DateUtils.parseZonedDateTime(startDateStr);
        ZonedDateTime endDate = DateUtils.parseZonedDateTime(endDateStr);
        SystemAnnouncement systemAnnouncement = this.readValues();
        this._save("scheduled", startDate, endDate, systemAnnouncement.getMessages());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> editAnnouncement(String language, String message, boolean override) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SystemAnnouncement systemAnnouncement = this.readValues();
        Map<String, String> messages = systemAnnouncement.getMessages();
        if (messages.containsKey(language) && !override) {
            result.put("already-exists", true);
            return result;
        }
        messages.put(language, message);
        this._save(systemAnnouncement.getState(), systemAnnouncement.getStartDate(), systemAnnouncement.getEndDate(), messages);
        return result;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map deleteAnnouncement(String language) throws ProcessingException {
        HashMap result = new HashMap();
        SystemAnnouncement systemAnnouncement = this.readValues();
        Map<String, String> messages = systemAnnouncement.getMessages();
        if (messages.containsKey(language)) {
            messages.remove(language);
            this._save(systemAnnouncement.getState(), systemAnnouncement.getStartDate(), systemAnnouncement.getEndDate(), messages);
        }
        return result;
    }

    private File _getSystemFile() {
        return FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"administrator", ADMINISTRATOR_SYSTEM_FILENAME});
    }

    private void _save(String state, ZonedDateTime startDate, ZonedDateTime endDate, Map<String, String> messages) throws ProcessingException {
        File systemFile = this._getSystemFile();
        try {
            if (!systemFile.exists()) {
                systemFile.getParentFile().mkdirs();
                systemFile.createNewFile();
            }
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            try (FileOutputStream os = new FileOutputStream(systemFile);){
                StreamResult sResult = new StreamResult(os);
                th.setResult(sResult);
                Properties format = new Properties();
                format.put("method", "xml");
                format.put("indent", "yes");
                format.put("encoding", "UTF-8");
                th.getTransformer().setOutputProperties(format);
                th.startDocument();
                AttributesImpl announcementsAttrs = new AttributesImpl();
                announcementsAttrs.addAttribute("", "state", "state", "CDATA", state);
                if (startDate != null) {
                    announcementsAttrs.addAttribute("", "start-date", "start-date", "CDATA", DateUtils.zonedDateTimeToString(startDate));
                }
                if (endDate != null) {
                    announcementsAttrs.addAttribute("", "end-date", "end-date", "CDATA", DateUtils.zonedDateTimeToString(endDate));
                }
                XMLUtils.startElement((ContentHandler)th, (String)"announcements", (Attributes)announcementsAttrs);
                for (String id : messages.keySet()) {
                    AttributesImpl announcementAttrs = new AttributesImpl();
                    if (!"*".equals(id)) {
                        announcementAttrs.addAttribute("", "lang", "lang", "CDATA", id);
                    }
                    XMLUtils.createElement((ContentHandler)th, (String)"announcement", (Attributes)announcementAttrs, (String)messages.get(id));
                }
                XMLUtils.endElement((ContentHandler)th, (String)"announcements");
                th.endDocument();
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to save system announcement values", (Throwable)e);
        }
        finally {
            this._cacheManager.get(SYSTEM_ANNOUNCEMENT_CACHE).invalidateAll();
        }
    }

    @Callable(rights={"*"})
    public boolean isSystemAnnouncementAvailable() {
        SystemAnnouncement systemAnnouncement = this.readValues();
        return systemAnnouncement.isAvailable();
    }

    public Map<String, Object> getSystemAnnouncementAvailability() {
        SystemAnnouncement announcement = this.readValues();
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("state", announcement.getState());
        result.put("start-date", announcement.getStartDate());
        result.put("end-date", announcement.getEndDate());
        return result;
    }

    public long getSystemAnnoucementLastModificationDate() {
        try {
            File systemFile = this._getSystemFile();
            if (!systemFile.exists() || !systemFile.isFile()) {
                return 0L;
            }
            return systemFile.lastModified();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get system announcements", e);
        }
    }

    public String getSystemAnnouncement(String languageCode) {
        SystemAnnouncement systemAnnouncement = this.readValues();
        if (!systemAnnouncement.isAvailable()) {
            return null;
        }
        Map<String, String> messages = systemAnnouncement.getMessages();
        String announcement = null;
        if (messages.containsKey(languageCode)) {
            announcement = messages.get(languageCode);
        }
        if (StringUtils.isEmpty(announcement)) {
            String defaultAnnouncement;
            String string = defaultAnnouncement = messages.containsKey("*") ? messages.get("*") : null;
            if (StringUtils.isEmpty((CharSequence)defaultAnnouncement)) {
                throw new IllegalStateException("There must be a default announcement.");
            }
            return defaultAnnouncement;
        }
        return announcement;
    }

    public SystemAnnouncement readValues() {
        Cache<String, SystemAnnouncement> cache = this._cacheManager.get(SYSTEM_ANNOUNCEMENT_CACHE);
        return cache.get(SYSTEM_ANNOUNCEMENT_CACHE_KEY, str -> this._readValues());
    }

    private SystemAnnouncement _readValues() {
        SystemAnnouncement announcement = new SystemAnnouncement();
        try {
            String endDate;
            Configuration configuration;
            File systemFile = this._getSystemFile();
            if (!systemFile.exists() || !systemFile.isFile()) {
                this._setDefaultValues();
            }
            try (FileInputStream is = new FileInputStream(systemFile);){
                configuration = new DefaultConfigurationBuilder().build((InputStream)is);
            }
            String state = configuration.getAttribute("state", "off");
            announcement.setState(state);
            String startDate = configuration.getAttribute("start-date", null);
            if (startDate != null) {
                announcement.setStartDate(DateUtils.parseZonedDateTime(startDate));
            }
            if ((endDate = configuration.getAttribute("end-date", null)) != null) {
                announcement.setEndDate(DateUtils.parseZonedDateTime(endDate));
            }
            for (Configuration announcementConfiguration : configuration.getChildren("announcement")) {
                String lang = announcementConfiguration.getAttribute("lang", "*");
                String message = announcementConfiguration.getValue();
                announcement.addMessage(lang, message);
            }
            return announcement;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get system announcements", e);
        }
    }

    private void _setDefaultValues() throws ProcessingException {
        Map objectModel = ContextHelper.getObjectModel((Context)this._context);
        Locale locale = I18nUtils.findLocale((Map)objectModel, (String)"locale", null, (Locale)Locale.getDefault(), (boolean)true);
        String defaultMessage = this._i18nUtils.translate(new I18nizableText("plugin.admin", "PLUGINS_ADMIN_SYSTEM_DEFAULTMESSAGE"), locale.getLanguage());
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put("*", defaultMessage);
        this._save("off", null, null, messages);
    }

    public static class SystemAnnouncement {
        private String _state = "off";
        private Map<String, String> _messages = new HashMap<String, String>();
        private ZonedDateTime _startDate = null;
        private ZonedDateTime _endDate = null;

        public boolean isAvailable() {
            return Strings.CS.equals(this._state, "on") || Strings.CS.equals(this._state, "scheduled") && (this._startDate == null || ZonedDateTime.now().isAfter(this._startDate)) && (this._endDate == null || ZonedDateTime.now().isBefore(this._endDate));
        }

        public Map<String, String> getMessages() {
            return this._messages;
        }

        public void setState(String state) {
            this._state = state;
        }

        public String getState() {
            return this._state;
        }

        public void setStartDate(ZonedDateTime startDate) {
            this._startDate = startDate;
        }

        public ZonedDateTime getStartDate() {
            return this._startDate;
        }

        public void setEndDate(ZonedDateTime endDate) {
            this._endDate = endDate;
        }

        public ZonedDateTime getEndDate() {
            return this._endDate;
        }

        public void addMessage(String lang, String message) {
            this._messages.put(lang, message);
        }
    }
}

