/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.request;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.servlet.AnalyseFileForVirusHelper;
import org.apache.cocoon.servlet.multipart.MultipartException;
import org.apache.cocoon.servlet.multipart.MultipartHttpServletRequest;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;

public class RequestFactory
extends org.apache.cocoon.servlet.multipart.RequestFactory {
    private boolean _antivirusEnabled;

    public RequestFactory(boolean saveUploadedFilesToDisk, File uploadDirectory, boolean allowOverwrite, boolean silentlyRename, int maxUploadSize, String defaultCharEncoding) {
        super(saveUploadedFilesToDisk, uploadDirectory, allowOverwrite, silentlyRename, maxUploadSize, defaultCharEncoding);
        if (ConfigManager.getInstance().isComplete()) {
            this._antivirusEnabled = AnalyseFileForVirusHelper.isAntivirusEnabled();
        }
    }

    public HttpServletRequest getServletRequest(HttpServletRequest request) throws IOException, MultipartException {
        HttpServletRequest servletRequest = super.getServletRequest(request);
        if (servletRequest instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipart = (MultipartHttpServletRequest)servletRequest;
            if (this._antivirusEnabled) {
                HashMap<String, Object> rejectedParam = new HashMap<String, Object>();
                Enumeration parameterNames = multipart.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    List valueList;
                    String name = (String)parameterNames.nextElement();
                    Object value = multipart.get(name);
                    if (value instanceof PartOnDisk) {
                        PartOnDisk diskPart = (PartOnDisk)value;
                        if (!this._analyseAndRejectFile(diskPart, name)) continue;
                        rejectedParam.put(name, new RejectedPart(diskPart.getHeaders(), 0, 0, 0));
                        continue;
                    }
                    if (!(value instanceof List) || (valueList = (List)value).isEmpty() || !(valueList.get(0) instanceof PartOnDisk)) continue;
                    ArrayList<Object> replaceFiles = new ArrayList<Object>();
                    for (PartOnDisk diskPart : valueList) {
                        if (this._analyseAndRejectFile(diskPart, name)) {
                            replaceFiles.add(new RejectedPart(diskPart.getHeaders(), 0, 0, 0));
                            continue;
                        }
                        replaceFiles.add(diskPart);
                    }
                    rejectedParam.put(name, replaceFiles);
                }
                if (!rejectedParam.isEmpty()) {
                    Hashtable<String, Object> params = new Hashtable<String, Object>();
                    parameterNames = multipart.getParameterNames();
                    while (parameterNames.hasMoreElements()) {
                        String name = (String)parameterNames.nextElement();
                        if (rejectedParam.containsKey(name)) {
                            params.put(name, rejectedParam.get(name));
                            continue;
                        }
                        params.put(name, multipart.get(name));
                    }
                    servletRequest = new MultipartHttpServletRequest(servletRequest, params);
                }
            }
        }
        return servletRequest;
    }

    private boolean _analyseAndRejectFile(PartOnDisk diskPart, String name) {
        File file = diskPart.getFile();
        if (!AnalyseFileForVirusHelper.analysefile(file.getAbsolutePath())) {
            file.delete();
            return true;
        }
        return false;
    }
}

