/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.ametys.runtime.config.Config;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalyseFileForVirusHelper {
    public static final Integer ANTIVIRUS_RESULT_OK = 0;
    private static final Logger __LOGGER = LoggerFactory.getLogger(AnalyseFileForVirusHelper.class);

    private AnalyseFileForVirusHelper() {
    }

    public static boolean isAntivirusEnabled() {
        return Config.getInstance().getValue("runtime.upload.antivirus.activated", false, false);
    }

    public static boolean analysefile(String absolutePath) {
        if (!AnalyseFileForVirusHelper.isAntivirusEnabled()) {
            return true;
        }
        try {
            String command = (String)Config.getInstance().getValue("runtime.upload.antivirus.command");
            Object[] cmdArray = StringUtils.split((String)command);
            cmdArray = (String[])Arrays.stream(cmdArray).map(str -> Strings.CS.replace(str, "%f", absolutePath)).toArray(String[]::new);
            if (__LOGGER.isDebugEnabled()) {
                __LOGGER.debug("Executing antivirus analysis : {}", (Object)StringUtils.join((Object[])cmdArray, (String)" "));
            }
            Process child = new ProcessBuilder((String[])cmdArray).redirectErrorStream(true).start();
            child.waitFor();
            if (__LOGGER.isDebugEnabled() || child.exitValue() == 2) {
                StringBuilder builder = new StringBuilder("Result of the command : (").append(child.exitValue()).append(")\n");
                try (InputStream in = child.getInputStream();){
                    String cmdOutput = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                    builder.append(cmdOutput);
                }
                if (child.exitValue() == 2) {
                    __LOGGER.error(builder.toString());
                } else {
                    __LOGGER.debug(builder.toString());
                }
            }
            return ANTIVIRUS_RESULT_OK.equals(child.exitValue());
        }
        catch (IOException | InterruptedException e) {
            __LOGGER.error("Unable to get output from the command", (Throwable)e);
            return false;
        }
    }
}

