/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.config.ConfigManager;
import org.ametys.runtime.data.AmetysHomeLock;
import org.ametys.runtime.data.AmetysHomeLockException;
import org.ametys.runtime.log.MemoryAppender;
import org.ametys.runtime.plugin.Init;
import org.ametys.runtime.plugin.InitExtensionPoint;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.PluginsComponentManager;
import org.ametys.runtime.plugins.admin.jvmstatus.ActiveSessionListener;
import org.ametys.runtime.request.RequestFactory;
import org.ametys.runtime.request.RequestListener;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.cocoon.Cocoon;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.Constants;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.http.HttpContext;
import org.apache.cocoon.environment.http.HttpEnvironment;
import org.apache.cocoon.servlet.multipart.MultipartHttpServletRequest;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.cocoon.util.log.SLF4JLoggerManager;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.EnumerationUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RuntimeServlet
extends HttpServlet {
    public static final String CONTEXT_SERVLET_CONFIG = "servlet-config";
    public static final String CONTEXT_CONTEXT_ROOT = "context-root";
    public static final String COCOON_CONF_URL = "/org/ametys/runtime/cocoon/cocoon.xconf";
    public static final int DEFAULT_MAX_UPLOAD_SIZE = 0xA00000;
    public static final String MAINTENANCE_FILENAME = "maintenance.xml";
    public static final String CONFIG_FILE_NAME = "config.xml";
    public static final String AMETYS_HOME_PROPERTY = "ametys.home.property";
    public static final String AMETYS_HOME_DEFAULT = "/WEB-INF/data";
    public static final String EXTERNAL_LOCATIONS = "WEB-INF/param/external-locations.xml";
    public static final String INSTANCE_FILENAME = "instance-info.xml";
    private static RunMode _runMode = RunMode.STARTING;
    private static MaintenanceStatus _maintenanceStatus;
    private static ForcedMainteanceInformations _forcedMainteanceInformations;
    private static Logger _logger;
    private static ServletContext _servletContext;
    private String _servletContextPath;
    private URL _servletContextURL;
    private File _ametysHome;
    private DefaultContext _avalonContext;
    private HttpContext _context;
    private Cocoon _cocoon;
    private RequestFactory _requestFactory;
    private File _workDir;
    private int _maxUploadSize = 0xA00000;
    private File _uploadDir;
    private File _cacheDir;
    private AmetysHomeLock _ametysHomeLock;
    private LoggerManager _loggerManager;
    private Throwable _exception;
    private Collection<Pattern> _allowedURLPattern = Arrays.asList(Pattern.compile("_admin($|/.*)"), Pattern.compile("plugins/[^/]+/resources/.*"));

    public void init() throws ServletException {
        try {
            if (System.getProperty("xml.catalog.ignoreMissing") == null) {
                System.setProperty("xml.catalog.ignoreMissing", "true");
            }
            _servletContext = this.getServletContext();
            _servletContext.addListener(ActiveSessionListener.class);
            this._servletContextPath = _servletContext.getRealPath("/");
            this._avalonContext = new DefaultContext();
            this._context = new HttpContext(_servletContext);
            this._avalonContext.put((Object)"environment-context", (Object)this._context);
            this._avalonContext.put((Object)"default-encoding", (Object)"UTF-8");
            this._avalonContext.put((Object)CONTEXT_SERVLET_CONFIG, (Object)this.getServletConfig());
            this._servletContextURL = new File(this._servletContextPath).toURI().toURL();
            this._avalonContext.put((Object)CONTEXT_CONTEXT_ROOT, (Object)this._servletContextURL);
            URL configFile = ((Object)((Object)this)).getClass().getResource(COCOON_CONF_URL);
            this._avalonContext.put((Object)"config-url", (Object)configFile);
            this._workDir = new File((File)_servletContext.getAttribute("javax.servlet.context.tempdir"), "cocoon-files");
            this._workDir.mkdirs();
            this._avalonContext.put((Object)"work-directory", (Object)this._workDir);
            this._cacheDir = new File(this._workDir, "cache-dir");
            this._cacheDir.mkdirs();
            this._avalonContext.put((Object)"cache-directory", (Object)this._cacheDir);
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tmpDir.exists()) {
                FileUtils.forceMkdir((File)tmpDir);
            }
            this._initAmetysHome();
            File config = FileUtils.getFile((File)this._ametysHome, (String[])new String[]{"config", CONFIG_FILE_NAME});
            String fileName = config.getCanonicalPath();
            Config.setFilename(fileName);
            this._initLogger();
            this._initAmetys();
        }
        catch (Throwable t) {
            RuntimeServlet.setRunMode(RunMode.FATALERROR);
            if (_logger != null) {
                _logger.error("Error while loading Ametys. Entering in error mode.", t);
            } else {
                System.out.println("Error while loading Ametys. Entering in error mode.");
                t.printStackTrace();
            }
            this._exception = t;
            this._disposeCocoon();
        }
    }

    private void _initAmetysHome() throws AmetysHomeLockException {
        String ametysHomePath = null;
        boolean hasAmetysHomeProp = EnumerationUtils.toList((Enumeration)this.getInitParameterNames()).contains(AMETYS_HOME_PROPERTY);
        if (!hasAmetysHomeProp) {
            System.out.println(String.format("[INFO] The '%s' servlet initialization parameter was not found. The Ametys home directory default value will be used '%s'", AMETYS_HOME_PROPERTY, AMETYS_HOME_DEFAULT));
        } else {
            String ametysHomeEnv = this.getInitParameter(AMETYS_HOME_PROPERTY);
            if (StringUtils.isEmpty((CharSequence)ametysHomeEnv)) {
                System.out.println(String.format("[WARN] The '%s' servlet initialization parameter appears to be empty. Ametys home directory default value will be used '%s'", AMETYS_HOME_PROPERTY, AMETYS_HOME_DEFAULT));
            } else {
                ametysHomePath = System.getenv(ametysHomeEnv);
                if (StringUtils.isEmpty((CharSequence)ametysHomePath)) {
                    System.out.println(String.format("[WARN] The '%s' environment variable was not found or was empty. Ametys home directory default value will be used '%s'", ametysHomeEnv, AMETYS_HOME_DEFAULT));
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)ametysHomePath)) {
            ametysHomePath = _servletContext.getRealPath(AMETYS_HOME_DEFAULT);
        }
        System.out.println("Acquiring lock on " + ametysHomePath);
        this._ametysHome = new File(ametysHomePath);
        this._ametysHome.mkdirs();
        this._ametysHomeLock = new AmetysHomeLock(this._ametysHome);
        this._ametysHomeLock.acquire();
    }

    public static String getInstanceId() {
        Path statisticsFile = AmetysHomeHelper.getAmetysHome().toPath().resolve(INSTANCE_FILENAME);
        if (Files.exists(statisticsFile, new LinkOption[0])) {
            String string;
            block9: {
                InputStream is = Files.newInputStream(statisticsFile, new OpenOption[0]);
                try {
                    Configuration configuration = new DefaultConfigurationBuilder().build(is);
                    string = configuration.getChild("unique-id").getValue();
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot read the ametys-home://instance-info.xml file. Consider remove it and restart Ametys to recreate it", e);
                    }
                }
                is.close();
            }
            return string;
        }
        throw new IllegalStateException("The file ametys-home://instance-info.xml does not exist while it should have created at startup");
    }

    private static void _createInstanceId() {
        try {
            Path statisticsFile = AmetysHomeHelper.getAmetysHome().toPath().resolve(INSTANCE_FILENAME);
            if (Files.exists(statisticsFile, new LinkOption[0])) {
                return;
            }
            String newId = UUID.randomUUID().toString();
            try (OutputStream os = Files.newOutputStream(statisticsFile, new OpenOption[0]);){
                TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
                StreamResult result = new StreamResult(os);
                th.setResult(result);
                Properties format = new Properties();
                format.put("method", "xml");
                format.put("indent", "yes");
                format.put("encoding", "UTF-8");
                format.put("{http://xml.apache.org/xalan}indent-amount", "2");
                th.getTransformer().setOutputProperties(format);
                th.startDocument();
                XMLUtils.startElement((ContentHandler)th, (String)"instance");
                XMLUtils.createElement((ContentHandler)th, (String)"unique-id", (String)newId);
                XMLUtils.endElement((ContentHandler)th, (String)"instance");
                th.endDocument();
            }
        }
        catch (Exception e) {
            _logger.error("Cannot create the instance id", (Throwable)e);
        }
    }

    private void _initAmetys() throws Exception {
        Long maxUploadSizeParam;
        RuntimeServlet.setRunMode(RunMode.STARTING);
        _maintenanceStatus = null;
        this._exception = null;
        this._loadRuntimeConfig();
        this._createCocoon();
        this._maxUploadSize = 0xA00000;
        this._uploadDir = new File(RuntimeConfig.getInstance().getAmetysHome(), "uploads");
        if (ConfigManager.getInstance().isComplete() && (maxUploadSizeParam = (Long)Config.getInstance().getValue("runtime.upload.max-size")) != null) {
            this._maxUploadSize = maxUploadSizeParam.intValue();
        }
        this._uploadDir.mkdirs();
        this._avalonContext.put((Object)"upload-directory", (Object)this._uploadDir);
        this._requestFactory = new RequestFactory(true, this._uploadDir, false, true, this._maxUploadSize, "UTF-8");
        RuntimeServlet._createInstanceId();
        PluginsComponentManager pluginCM = (PluginsComponentManager)_servletContext.getAttribute("PluginsComponentManager");
        if (RuntimeServlet.doMigrationAndInit(pluginCM)) {
            this.restartCocoon(null);
        } else if (PluginsManager.getInstance().isSafeMode()) {
            RuntimeServlet.setRunMode(RunMode.SAFEMODE);
        } else if (RuntimeServlet.getMaintenanceStatus() != MaintenanceStatus.NONE) {
            RuntimeServlet.setRunMode(RunMode.MAINTENANCE);
        } else {
            RuntimeServlet.setRunMode(RunMode.NORMAL);
        }
    }

    private void _initLogger() {
        String logj4fFile = _servletContext.getRealPath("/WEB-INF/log4j.xml");
        System.setProperty("ametys.home.dir", this._ametysHome.getAbsolutePath());
        DOMConfigurator.configure((String)logj4fFile);
        System.clearProperty("ametys.home.dir");
        MemoryAppender appender = new MemoryAppender();
        appender.setName("memory-appender");
        LogManager.getRootLogger().addAppender((Appender)appender);
        Enumeration categories = LogManager.getCurrentLoggers();
        while (categories.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)categories.nextElement();
            logger.addAppender((Appender)appender);
        }
        this._loggerManager = new SLF4JLoggerManager();
        _logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    private void _createCocoon() throws Exception {
        this._avalonContext.put((Object)"class-loader", (Object)((Object)((Object)this)).getClass().getClassLoader());
        this._avalonContext.put((Object)"classpath", (Object)"");
        URL configFile = (URL)this._avalonContext.get((Object)"config-url");
        _logger.info("Reloading from: {}", (Object)configFile.toExternalForm());
        Cocoon c = (Cocoon)ClassUtils.newInstance((String)"org.apache.cocoon.Cocoon");
        ContainerUtil.enableLogging((Object)c, (org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(_logger));
        c.setLoggerManager(this._loggerManager);
        ContainerUtil.contextualize((Object)c, (Context)this._avalonContext);
        ContainerUtil.initialize((Object)c);
        this._cocoon = c;
    }

    public static boolean doMigrationAndInit(PluginsComponentManager pluginCM) throws Exception {
        if (RuntimeServlet._initMigration(pluginCM)) {
            return true;
        }
        RuntimeServlet._initPlugins(pluginCM);
        return false;
    }

    private static void _initPlugins(PluginsComponentManager pluginCM) throws Exception {
        RuntimeServlet.setRunMode(RunMode.INITIALIZING);
        if (!PluginsManager.getInstance().isSafeMode()) {
            InitExtensionPoint initExtensionPoint = (InitExtensionPoint)pluginCM.lookup(InitExtensionPoint.ROLE);
            for (String id : initExtensionPoint.getExtensionsIds()) {
                Init init = (Init)initExtensionPoint.getExtension(id);
                init.init();
            }
            if (pluginCM.hasComponent(Init.ROLE)) {
                Init init = (Init)pluginCM.lookup(Init.ROLE);
                init.init();
            }
        }
    }

    private static boolean _initMigration(PluginsComponentManager pluginCM) throws Exception {
        RuntimeServlet.setRunMode(RunMode.MIGRATING);
        MigrationEngine migrationEngine = (MigrationEngine)pluginCM.lookup(MigrationEngine.ROLE);
        return migrationEngine.migrate();
    }

    private void _loadRuntimeConfig() throws ServletException {
        Configuration externalConf;
        Configuration runtimeConf;
        block15: {
            runtimeConf = null;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                URL schemaURL = ((Object)((Object)this)).getClass().getResource("runtime-4.1.xsd");
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
                factory.setSchema(schema);
                XMLReader reader = factory.newSAXParser().getXMLReader();
                DefaultConfigurationBuilder runtimeConfBuilder = new DefaultConfigurationBuilder(reader);
                File runtimeConfigFile = new File(this._servletContextPath, "WEB-INF/param/runtime.xml");
                try (FileInputStream runtime = new FileInputStream(runtimeConfigFile);){
                    runtimeConf = runtimeConfBuilder.build((InputStream)runtime, runtimeConfigFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                _logger.error("Unable to load runtime file at 'WEB-INF/param/runtime.xml'. PluginsManager will enter in safe mode.", (Throwable)e);
            }
            externalConf = null;
            try {
                DefaultConfigurationBuilder externalConfBuilder = new DefaultConfigurationBuilder();
                File externalConfigFile = new File(this._servletContextPath, EXTERNAL_LOCATIONS);
                if (!externalConfigFile.exists()) break block15;
                try (FileInputStream external = new FileInputStream(externalConfigFile);){
                    externalConf = externalConfBuilder.build((InputStream)external, externalConfigFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                _logger.error("Unable to load external locations values at WEB-INF/param/external-locations.xml", (Throwable)e);
                throw new ServletException("Unable to load external locations values at WEB-INF/param/external-locations.xml", (Throwable)e);
            }
        }
        RuntimeConfig.configure(runtimeConf, externalConf, this._ametysHome, this._servletContextPath);
    }

    public void destroy() {
        RuntimeServlet.setRunMode(RunMode.STOPPING);
        if (this._cocoon != null) {
            _logger.debug("Servlet destroyed - disposing Cocoon");
            this._disposeCocoon();
        }
        if (this._ametysHomeLock != null) {
            this._ametysHomeLock.release();
            this._ametysHomeLock = null;
        }
        this._avalonContext = null;
        _logger = null;
        this._loggerManager = null;
    }

    private final void _disposeCocoon() {
        if (this._cocoon != null) {
            ContainerUtil.dispose((Object)this._cocoon);
            this._cocoon = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        req.setCharacterEncoding("UTF-8");
        res.addHeader("X-Cocoon-Version", Constants.VERSION);
        if (this._exception != null) {
            this._renderError(req, res, this._exception, "An error occured during Ametys initialization.");
            return;
        }
        if (this._cocoon == null) {
            this._renderError(req, res, null, "Ametys is restarting. Please try again later.");
            return;
        }
        String uri = this._retrieveUri(req);
        if (PluginsManager.getInstance().isSafeMode()) {
            String finalUri = uri;
            boolean allowed = this._allowedURLPattern.stream().anyMatch(p -> p.matcher(finalUri).matches());
            if (!allowed) {
                res.addHeader("X-Ametys-SafeMode", "true");
                PluginsManager.Status status = PluginsManager.getInstance().getStatus();
                if (status == PluginsManager.Status.NO_CONFIG) {
                    res.sendRedirect(req.getContextPath() + "/_admin/public/first-start.html");
                    return;
                }
                if (status == PluginsManager.Status.CONFIG_INCOMPLETE) {
                    res.sendRedirect(req.getContextPath() + "/_admin/public/load-config.html");
                    return;
                }
                res.sendRedirect(req.getContextPath() + "/_admin/public/safe-mode.html");
                return;
            }
        }
        UserIdentity authenticatedUser = null;
        HttpSession session = req.getSession(false);
        if (session != null) {
            authenticatedUser = (UserIdentity)session.getAttribute("Runtime:UserIdentity");
        }
        MDC.remove((String)"user");
        if (authenticatedUser != null) {
            MDC.put((String)"user", (String)UserIdentity.userIdentityToString(authenticatedUser));
        }
        MDC.put((String)"requestURI", (String)req.getRequestURI());
        StopWatch stopWatch = new StopWatch();
        HttpServletRequest request = null;
        try {
            stopWatch.start();
            this._fireRequestStarted(req);
            request = this._requestFactory.getServletRequest(req);
            HttpEnvironment env = new HttpEnvironment(uri, this._servletContextURL.toExternalForm(), request, res, _servletContext, this._context, "UTF-8", "UTF-8");
            env.enableLogging((org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(_logger));
            if (!this._cocoon.process((Environment)env)) {
                _logger.error("The Cocoon engine failed to process the request.");
                this._renderError(request, res, null, "Cocoon engine failed to process the request");
            }
        }
        catch (IOException | ConnectionResetException | ResourceNotFoundException e) {
            _logger.warn(e.toString());
            this._renderError(request, res, e, e.getMessage());
        }
        catch (Throwable e) {
            _logger.error("Internal Cocoon Problem", e);
            this._renderError(request, res, e, "Internal Cocoon Problem");
        }
        finally {
            stopWatch.stop();
            _logger.info("'{}' processed in {} ms.", (Object)uri, (Object)stopWatch.getDuration());
            try {
                if (request instanceof MultipartHttpServletRequest) {
                    _logger.debug("Deleting uploaded file(s).");
                    ((MultipartHttpServletRequest)request).cleanup();
                }
            }
            catch (IOException e) {
                _logger.error("Cocoon got an Exception while trying to cleanup the uploaded files.", (Throwable)e);
            }
        }
        this._fireRequestEnded(req);
        if (Boolean.TRUE.equals(req.getAttribute("org.ametys.runtime.reload"))) {
            this.restartCocoon(req);
        }
    }

    public void restartCocoon(HttpServletRequest req) {
        try {
            boolean wasForcedSafeMode;
            ConfigManager.getInstance().dispose();
            this._disposeCocoon();
            _servletContext.removeAttribute("PluginsComponentManager");
            boolean forceSafeMode = wasForcedSafeMode = PluginsManager.getInstance().getStatus() == PluginsManager.Status.SAFE_MODE_FORCED;
            if (req != null && !(forceSafeMode = Boolean.TRUE.equals(req.getAttribute("org.ametys.runtime.reload.safeMode")))) {
                forceSafeMode = wasForcedSafeMode && !Boolean.TRUE.equals(req.getAttribute("org.ametys.runtime.reload.normalMode"));
            }
            _servletContext.setAttribute("org.ametys.runtime.forceSafeMode", (Object)forceSafeMode);
            this._initAmetys();
        }
        catch (Exception e) {
            RuntimeServlet.setRunMode(RunMode.FATALERROR);
            _logger.error("Error while reloading Ametys. Entering in error mode.", (Throwable)e);
            this._exception = e;
        }
    }

    private String _retrieveUri(HttpServletRequest req) {
        Object uri = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            uri = (String)uri + pathInfo;
        }
        if (((String)uri).length() > 0 && ((String)uri).charAt(0) == '/') {
            uri = ((String)uri).substring(1);
        }
        return uri;
    }

    private void _fireRequestStarted(HttpServletRequest req) {
        Collection listeners = (Collection)_servletContext.getAttribute("runtime:requestListeners");
        if (listeners == null) {
            return;
        }
        for (RequestListener listener : listeners) {
            listener.requestStarted(req);
        }
    }

    private void _fireRequestEnded(HttpServletRequest req) {
        Collection listeners = (Collection)_servletContext.getAttribute("runtime:requestListeners");
        if (listeners == null) {
            return;
        }
        for (RequestListener listener : listeners) {
            listener.requestEnded(req);
        }
    }

    public static void setMaintenanceStatus(MaintenanceStatus maintenanceStatus, ForcedMainteanceInformations forcedMainteanceInformations) {
        ForcedMainteanceInformations fixedForcedMainteanceInformations;
        block16: {
            if (_maintenanceStatus != maintenanceStatus) {
                LoggerFactory.getLogger(Runtime.class).debug("Switching maintenance status from " + String.valueOf((Object)_maintenanceStatus) + " to " + String.valueOf((Object)maintenanceStatus));
            }
            fixedForcedMainteanceInformations = null;
            if (forcedMainteanceInformations != null) {
                fixedForcedMainteanceInformations = new ForcedMainteanceInformations(StringUtils.defaultString((String)forcedMainteanceInformations.comment).replaceAll("\r?\n", "<br/>"), forcedMainteanceInformations.initiator, forcedMainteanceInformations.since);
            }
            try {
                File maintenanceFile = FileUtils.getFile((File)AmetysHomeHelper.getAmetysHome(), (String[])new String[]{"administrator", MAINTENANCE_FILENAME});
                if (maintenanceStatus != MaintenanceStatus.FORCED) {
                    if (maintenanceFile.exists()) {
                        FileUtils.delete((File)maintenanceFile);
                    }
                    break block16;
                }
                maintenanceFile.getParentFile().mkdirs();
                try (FileOutputStream os = new FileOutputStream(maintenanceFile);){
                    TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
                    StreamResult result = new StreamResult(os);
                    th.setResult(result);
                    Properties format = new Properties();
                    format.put("method", "xml");
                    format.put("indent", "yes");
                    format.put("encoding", "UTF-8");
                    format.put("{http://xml.apache.org/xalan}indent-amount", "2");
                    th.getTransformer().setOutputProperties(format);
                    th.startDocument();
                    XMLUtils.startElement((ContentHandler)th, (String)"maintenance");
                    if (fixedForcedMainteanceInformations != null) {
                        XMLUtils.createElement((ContentHandler)th, (String)"comment", (String)StringUtils.defaultString((String)fixedForcedMainteanceInformations.comment));
                        XMLUtils.createElement((ContentHandler)th, (String)"initiator", (String)StringUtils.defaultString((String)UserIdentity.userIdentityToString(fixedForcedMainteanceInformations.initiator)));
                        if (fixedForcedMainteanceInformations.since != null) {
                            XMLUtils.createElement((ContentHandler)th, (String)"since", (String)DateUtils.zonedDateTimeToString(fixedForcedMainteanceInformations.since));
                        }
                    }
                    XMLUtils.endElement((ContentHandler)th, (String)"maintenance");
                    th.endDocument();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot change maintenance status", e);
            }
        }
        _maintenanceStatus = maintenanceStatus;
        _forcedMainteanceInformations = fixedForcedMainteanceInformations;
        try {
            PluginsComponentManager pluginCM = (PluginsComponentManager)_servletContext.getAttribute("PluginsComponentManager");
            ObservationManager observationManager = (ObservationManager)pluginCM.lookup(ObservationManager.ROLE);
            CurrentUserProvider currentUserProvider = (CurrentUserProvider)pluginCM.lookup(CurrentUserProvider.ROLE);
            if (observationManager != null) {
                observationManager.notify(new Event("runtime.maintenance", currentUserProvider.getUser(), Map.of()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MaintenanceStatus getMaintenanceStatus() {
        if (_maintenanceStatus == null) {
            File maintenanceFile = FileUtils.getFile((File)AmetysHomeHelper.getAmetysHome(), (String[])new String[]{"administrator", MAINTENANCE_FILENAME});
            if (!maintenanceFile.exists()) {
                _maintenanceStatus = MaintenanceStatus.NONE;
            } else {
                _maintenanceStatus = MaintenanceStatus.FORCED;
                try {
                    Configuration configuration = new DefaultConfigurationBuilder().buildFromFile(maintenanceFile);
                    _forcedMainteanceInformations = new ForcedMainteanceInformations(configuration.getChild("comment").getValue(""), UserIdentity.stringToUserIdentity(configuration.getChild("initiator").getValue(null)), DateUtils.parseZonedDateTime(configuration.getChild("since").getValue(null)));
                }
                catch (IOException | ConfigurationException | SAXException e) {
                    _logger.error("Cannot read the maintenance status file", e);
                    _forcedMainteanceInformations = null;
                }
            }
        }
        return _maintenanceStatus;
    }

    public static ForcedMainteanceInformations getMaintenanceStatusForcedInformations() {
        return _forcedMainteanceInformations;
    }

    public static void setRunMode(RunMode mode) {
        if (_runMode != mode) {
            LoggerFactory.getLogger(RuntimeServlet.class).debug("Switching run mode from " + String.valueOf((Object)_runMode) + " to " + String.valueOf((Object)mode));
        }
        _runMode = mode;
    }

    public static RunMode getRunMode() {
        return _runMode;
    }

    private void _renderError(HttpServletRequest req, HttpServletResponse res, Throwable throwable, String message) throws ServletException {
        ServletConfig config = this.getServletConfig();
        if (config == null) {
            throw new ServletException("Cannot access to ServletConfig");
        }
        try {
            TransformerHandler th;
            ServletOutputStream os = res.getOutputStream();
            String path = req.getRequestURI().substring(req.getContextPath().length());
            if (path.equals("/favicon.ico")) {
                try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("favicon.ico");){
                    res.setStatus(200);
                    res.setContentType(config.getServletContext().getMimeType("favicon.ico"));
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    return;
                }
            }
            res.setStatus(500);
            res.setContentType("text/html; charset=UTF-8");
            SAXTransformerFactory saxFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("fatal.xsl");){
                StreamSource errorSource = new StreamSource(is);
                th = saxFactory.newTransformerHandler(errorSource);
            }
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("encoding", "UTF-8");
            format.put("doctype-system", "about:legacy-compat");
            th.getTransformer().setOutputProperties(format);
            th.getTransformer().setParameter("code", 500);
            th.getTransformer().setParameter("realPath", config.getServletContext().getRealPath("/"));
            th.getTransformer().setParameter("contextPath", req.getContextPath());
            StreamResult result = new StreamResult((OutputStream)os);
            th.setResult(result);
            th.startDocument();
            XMLUtils.startElement((ContentHandler)th, (String)"http://apache.org/cocoon/exception/1.0", (String)"exception-report");
            XMLUtils.startElement((ContentHandler)th, (String)"http://apache.org/cocoon/exception/1.0", (String)"message");
            XMLUtils.data((ContentHandler)th, (String)message);
            XMLUtils.endElement((ContentHandler)th, (String)"http://apache.org/cocoon/exception/1.0", (String)"message");
            XMLUtils.startElement((ContentHandler)th, (String)"http://apache.org/cocoon/exception/1.0", (String)"stacktrace");
            if (throwable != null) {
                XMLUtils.data((ContentHandler)th, (String)ExceptionUtils.getStackTrace((Throwable)throwable));
            }
            XMLUtils.endElement((ContentHandler)th, (String)"http://apache.org/cocoon/exception/1.0", (String)"stacktrace");
            XMLUtils.endElement((ContentHandler)th, (String)"http://apache.org/cocoon/exception/1.0", (String)"ex:exception-report");
            th.endDocument();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static enum RunMode {
        STARTING,
        MIGRATING,
        INITIALIZING,
        NORMAL,
        MAINTENANCE,
        SAFEMODE,
        FATALERROR,
        STOPPING;

    }

    public static enum MaintenanceStatus {
        NONE,
        AUTOMATIC,
        FORCED;

    }

    public record ForcedMainteanceInformations(String comment, UserIdentity initiator, ZonedDateTime since) {
    }
}

