/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.util;

import java.lang.annotation.Annotation;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Annotations {
    private static final Logger __LOGGER = LoggerFactory.getLogger(Annotations.class);

    private Annotations() {
    }

    public static boolean isAnnotationPresent(Class<?> classToTest, Class<? extends Annotation> annotationClass) {
        if (__LOGGER.isDebugEnabled()) {
            __LOGGER.debug("[BEGIN] Test if annotation {} is present for {}", (Object)annotationClass.getName(), (Object)classToTest.getName());
        }
        try {
            boolean bl = Annotations._isAnnotationPresent(classToTest, annotationClass) || Annotations._isAnnotationPresentOnInterfacesOfSuperclasses(classToTest, annotationClass);
            return bl;
        }
        finally {
            if (__LOGGER.isDebugEnabled()) {
                __LOGGER.debug("[END] Test if annotation {} is present for {} done", (Object)annotationClass.getName(), (Object)classToTest.getName());
            }
        }
    }

    private static boolean _isAnnotationPresent(Class<?> classToTest, Class<? extends Annotation> annotationClass) {
        boolean result = classToTest.isAnnotationPresent(annotationClass);
        if (result && __LOGGER.isDebugEnabled()) {
            String additionalText = classToTest.isInterface() ? "" : "(or on one of its ancestors)";
            __LOGGER.debug("[FOUND] annotation {} is present on {} {}", new Object[]{annotationClass.getName(), classToTest.getName(), additionalText});
        }
        return result;
    }

    private static boolean _isAnnotationPresentOnInterfacesOfSuperclasses(Class<?> classToTest, Class<? extends Annotation> annotationClass) {
        return Annotations._getSuperclassesAndSelf(classToTest).anyMatch(superclass -> Annotations._isAnnotationPresentOnInterfaces(superclass, annotationClass));
    }

    private static Stream<Class<?>> _getSuperclassesAndSelf(Class<?> classToTest) {
        if (classToTest == null || classToTest == Object.class) {
            return Stream.empty();
        }
        __LOGGER.debug("found class {}", (Object)classToTest.getName());
        return Stream.concat(Stream.of(classToTest), Annotations._getSuperclassesAndSelf(classToTest.getSuperclass()));
    }

    private static boolean _isAnnotationPresentOnInterfaces(Class<?> classToTest, Class<? extends Annotation> annotationClass) {
        return Annotations._getAncestorInterfacesAndSelf(classToTest).anyMatch(theInterface -> Annotations._isAnnotationPresent(theInterface, annotationClass));
    }

    private static Stream<Class<?>> _getAncestorInterfacesAndSelf(Class<?> classToTest) {
        return Stream.concat(Stream.of(classToTest), Annotations._getAncestorInterfaces(classToTest));
    }

    private static Stream<Class<?>> _getAncestorInterfaces(Class<?> classToTest) {
        return Annotations._getInterfaces(classToTest).map(Annotations::_getAncestorInterfacesAndSelf).flatMap(Function.identity());
    }

    private static Stream<Class<?>> _getInterfaces(Class<?> classToTest) {
        Class<?>[] interfaces = classToTest.getInterfaces();
        if (__LOGGER.isDebugEnabled()) {
            __LOGGER.debug("found interfaces {}", Stream.of(interfaces).map(Class::getName).collect(Collectors.toList()));
        }
        return Stream.of(interfaces);
    }

    public static <A extends Annotation, T> Stream<T> getAnnotationAttributeValues(Class<?> classToTest, Class<A> annotationClass, BiFunction<A, Class<?>, T> annotationAttributeGetter) {
        return Annotations._getSuperclassesAndSelf(classToTest).flatMap(Annotations::_getAncestorInterfacesAndSelf).map(classOrInterface -> Pair.of(classOrInterface.getAnnotation(annotationClass), (Object)classOrInterface)).filter(annotationAndClass -> annotationAndClass.getLeft() != null).map(annotationAndClass -> Annotations._logAndGet(annotationAttributeGetter, (Class)annotationAndClass.getRight(), (Annotation)annotationAndClass.getLeft()));
    }

    private static <A extends Annotation, T> T _logAndGet(BiFunction<A, Class<?>, T> annotationAttributeGetter, Class<?> annotated, A annotation) {
        T result = annotationAttributeGetter.apply(annotation, annotated);
        if (__LOGGER.isDebugEnabled()) {
            __LOGGER.debug("value '{}' retrieved from {}", result, (Object)annotated.getName());
        }
        return result;
    }
}

