/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class ParameterizedTypesHelper {
    private ParameterizedTypesHelper() {
    }

    public static <T> Class<T> getFirstActualClassArgument(Class<?> baseClass, Class<?> clazz) throws IllegalArgumentException {
        if (!baseClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Unable to retrieve the first argument of " + clazz.getName() + ". This class is not a subclass of " + baseClass.getName());
        }
        Class firstClassArgument = null;
        Class<?> currentClass = clazz;
        while (!currentClass.equals(baseClass)) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Type superType = currentClass.getGenericSuperclass();
            if (superType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)superType).getActualTypeArguments()).length > 0 && actualTypeArguments[0] instanceof Class) {
                firstClassArgument = (Class)actualTypeArguments[0];
            }
            currentClass = currentClass.getSuperclass();
        }
        return firstClassArgument;
    }
}

