/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.runtime.workspace;

import java.io.IOException;
import java.util.Map;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.ametys.runtime.workspace.Workspace;
import org.ametys.runtime.workspace.WorkspaceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WorkspacesGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        this._saxWorkspaces();
        this.contentHandler.endDocument();
    }

    private void _saxWorkspaces() throws SAXException {
        String defaultWorkspace = RuntimeConfig.getInstance().getDefaultWorkspace();
        AttributesImpl attrs2 = new AttributesImpl();
        attrs2.addCDATAAttribute("default", defaultWorkspace);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"workspaces", (Attributes)attrs2);
        for (Workspace workspace : WorkspaceManager.getInstance().getWorkspaces().values()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"workspace");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"name", (String)workspace.getName());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"theme", (String)workspace.getThemeName());
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"workspace");
        }
        Map<String, WorkspaceManager.InactivityCause> inactiveWorkspaces = WorkspaceManager.getInstance().getInactiveWorkspaces();
        for (String workspace : inactiveWorkspaces.keySet()) {
            WorkspaceManager.InactivityCause inactivityCause = inactiveWorkspaces.get(workspace);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("inactive", "true");
            attrs.addCDATAAttribute("cause", inactivityCause.toString());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"workspace", (Attributes)attrs, (String)workspace);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"workspaces");
    }
}

