/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class to handle actions cache grid.
 */
Ext.define('Ametys.plugins.admin.cache.CacheActions', {
	singleton: true,

	/**
	 * Clean the selected cache
	 * @param controller The controller calling this function
	 */
	clearCache: function (controller) 
	{
		var cacheIds = []
		var cacheTargets = Ametys.message.MessageBus.getCurrentSelectionMessage().getTargets(Ametys.message.MessageTarget.CACHE);
		if (cacheTargets.length > 0)
		{
			for (var i = 0; i < cacheTargets.length; i++)
			{
				cacheIds.push(cacheTargets[i].getParameters().id);
			}
			controller.serverCall(
				'clearCaches',
				[cacheIds],
				Ext.bind(this._clearCacheCb, this, [cacheIds], false),
				{
					errorMessage: { msg: "{{i18n PLUGINS_ADMIN_TOOL_CLEAR_CACHE_ERROR}}", category: this.self.getName() },
					ignoreCallbackOnError: true
				}
			);
		}
	},

	/**
	 * @private 
	 * Callback for the clean process
	 * @param {String[]} cacheIds the list of id that were sent to the server
	 */
	_clearCacheCb: function (cacheIds) 
	{
		if (cacheIds && cacheIds.length > 0)
		{
			var targets = [];
			cacheIds.forEach(function (id)
			{
				targets.push({
					id: Ametys.message.MessageTarget.CACHE,
					parameters: { id: id }
				});
			});
			Ext.create('Ametys.message.Message', {
				type: Ametys.message.Message.MODIFIED,
				targets: targets
			});

			Ametys.notify({
				title: "{{i18n PLUGINS_ADMIN_TOOL_CLEAR_CACHE_TITLE}}",
				description: "{{i18n PLUGINS_ADMIN_TOOL_CLEAR_CACHE_SUCCESS}}"
			});
		}
		
	},
    
    /**
     * Clean all the memory caches
     * @param controller The controller calling this function
     */
     clearAllCaches: function(controller)
    {
        controller.serverCall(
            'clearAllCaches',
            [],
            this._clearAllCachesCb,
            {
                errorMessage: { msg: "{{i18n PLUGINS_ADMIN_TOOL_CLEAR_ALL_CACHES_ERROR}}", category: this.self.getName() },
                ignoreCallbackOnError: true
            }
        );
    },
    
    /**
     * @private 
     * Callback for the clean process
     */
    _clearAllCachesCb: function (cleanedCacheIds) 
    {
        if (cleanedCacheIds && cleanedCacheIds.length > 0)
        {
            var targets = [];
            cleanedCacheIds.forEach(function (id)
            {
                targets.push({
                    id: Ametys.message.MessageTarget.CACHE,
                    parameters: { id: id }
                });
            });
            Ext.create('Ametys.message.Message', {
                type: Ametys.message.Message.MODIFIED,
                targets: targets
            });

            Ametys.notify({
                title: "{{i18n PLUGINS_ADMIN_TOOL_CLEAR_ALL_CACHES_TITLE}}",
                description: "{{i18n PLUGINS_ADMIN_TOOL_CLEAR_ALL_CACHES_SUCCESS}}"
            });
        }
        
    },

    /**
     * Empty the cocoon cache
     */
    emptyCocoonCache: function(controller) 
    {
        controller.serverCall(
            'emptyCocoonCache',
            [],
            Ext.bind(this._emptyCocoonCacheCb, this),
            {
                errorMessage: { msg: "{{i18n PLUGINS_ADMIN_CACHE_EMPTYCOCOON_DONE_ERROR}}", category: this.self.getName() },
                ignoreCallbackOnError: true
            }
        );        
    },
    
    /**
     * Cb
     * @private
     */
    _emptyCocoonCacheCb: function()
    {
        Ametys.notify({
            title: "{{i18n PLUGINS_ADMIN_CACHE_EMPTYCOCOON_DONE_TITLE}}",
            description: "{{i18n PLUGINS_ADMIN_CACHE_EMPTYCOCOON_DONE_SUCCESS}}"
        });
    }
});