/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class controls a ribbon button to clear caches. 
 * There should be at least one memory cache selected to enable the button.
 * @private
 */
Ext.define('Ametys.plugins.admin.cache.ClearCacheButtonController', {
    extend: 'Ametys.ribbon.element.ui.ButtonController',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        
        Ametys.message.MessageBus.on(Ametys.message.Message.MODIFIED, this._onModified, this);
    },
    
    /**
     * @private
     * Listener when a new cache is selected
     * Will update the state of the button effectively upon the current selection.
     * @param {Ametys.message.Message} message The moved message.
     */
    _onModified: function (message)
    {
        if (this.updateTargetsInCurrentSelectionTargets(message))
        {
            this.refresh();
        }
    },
    
    updateState: function()
    {
        this.disable();
        
        var targets = this.getMatchingTargets();
        
        if (targets.length > 0)
        {

            var areAnyMemoryCache = false;
            var areAnyRequestCache = false;
            
            for (var i = 0; i < targets.length; i++)
            {
                if (targets[i].getParameters().type == "MEMORY")
                {
                    areAnyMemoryCache = true
                }
                else if (targets[i].getParameters().type == "REQUEST")
                {
                    areAnyRequestCache = true
                }
                
            }
            
            if (areAnyMemoryCache && !areAnyRequestCache)
            {
                this.enable();
                this.setAdditionalDescription("");
            }
            else if (!areAnyMemoryCache && areAnyRequestCache)
            {
                this.disable();
                this.setAdditionalDescription(this.getInitialConfig("request-selected-description"));
            }
            else
            {
                this.enable();
                this.setAdditionalDescription(this.getInitialConfig("request-selected-description"));
            }
        }

    },

});