/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Thread actions
 */
Ext.define('Ametys.plugins.admin.jvmstatus.ThreadsActions', {
    singleton: true,
    
    /**
     * Ask the thread dump to the server
     */
    dump: function(controller)
    {
        Ametys.data.ServerComm.callMethod({
            role: "org.ametys.runtime.plugins.admin.jvmstatus.ThreadInfo",
            methodName: "getThreadDump",
            parameters: [],
            callback: {
                scope: this,
                handler: this._dumpCB,
            },
            errorMessage: true
        });
        
    },
    
    /**
     * @private
     */
    _dumpCB: function(threadInfo)
    {
        var file = new Blob([threadInfo.data], {type: "text/plain"});
        var a = document.createElement("a"),
                url = URL.createObjectURL(file);
        a.href = url;
        a.download = "ametys-threaddump-" + threadInfo.date + ".txt";
        document.body.appendChild(a);
        a.click();
        setTimeout(function() {
            document.body.removeChild(a);
            window.URL.revokeObjectURL(url);  
        }, 0);    

    }
});