/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for unknown user entries
 * @private
 */
Ext.define("Ametys.plugins.admin.user.UnknownUser", {
    extend: 'Ext.data.Model',
    
    fields: [
        'login',
        'populationId',
        // use the popultionId as a fallback for the label
        {name: 'populationLabel', convert: (value, record) => value ? value : record.get("populationId")},
        'firstname',
        'lastname',
        {name: 'fullname', calculate: data => 
            // lastname is mandatory so we only check emptiness of firstname
            data.firstname ? `${data.lastname} ${data.firstname}` : data.lastname
        },
        'email',
        {name: 'last_connection_date', type: 'date', dateFormat: Ext.Date.patterns.ISO8601DateTime},
        {name: 'missing_date', type: 'date', dateFormat: Ext.Date.patterns.ISO8601DateTime},
        {name: 'forget', type: 'boolean'}
    ]
});
