/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
Ext.define("Ametys.plugins.admin.user.UnknownUserMessageTarget", {
        override: "Ametys.message.MessageTarget",
        
        statics: 
        {
            /**
             * @member Ametys.message.MessageTarget
             * @readonly
             * @property {String} UNKNOWN_USER The target type is an obsolete user. The expected parameters are:
             * @property {String} UNKNOWN_USER.login The user login
             * @property {String} UNKNOWN_USER.population The user population
             * @property {Boolean} UNKNOWN_USER.forget Indicate if the user is in the process of being forgotten
             */
            UNKNOWN_USER: "unknown-user"
        }
    }
);
