/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let userPopulations = "ametys-home://config/user-populations.xml"

let containsFormCredentialProviders = Ametys.utils.contains(userPopulations, /<credentialProvider[^>]+modelId="org\.ametys\.core\.authentication\.FormBased"[^>]+>/g)
let containsStorePasswordInSessionParameter = Ametys.utils.contains(userPopulations, /(<runtime.authentication.form.store-password-in-session)/g)

if (containsFormCredentialProviders && !containsStorePasswordInSessionParameter)
{
    Ametys.utils.searchAndReplace(userPopulations, 
        /(<credentialProvider[^>]+modelId="org\.ametys\.core\.authentication\.FormBased"[^>]+>)/g,
        '$1<runtime.authentication.form.store-password-in-session>false</runtime.authentication.form.store-password-in-session>');
    
    logger.info("Migration needs a restart of the application");
    actionData.setRequiresRestart(true);
}