/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let userPopulations = "ametys-home://config/user-populations.xml"

let containsJbdcUserDirectories = Ametys.utils.contains(userPopulations, /<userDirectory[^>]+modelId="org\.ametys\.plugins\.core\.user\.directory\.Jdbc"[^>]+>/g)
let containsStrongPasswordParameter = Ametys.utils.contains(userPopulations, /(<runtime.users.jdbc.strong.password)/g)

if (containsJbdcUserDirectories && !containsStrongPasswordParameter)
{
    Ametys.utils.searchAndReplace(userPopulations, 
        /(<userDirectory[^>]+modelId="org\.ametys\.plugins\.core\.user\.directory\.Jdbc"[^>]+>)/g,
        '$1\n<runtime.users.jdbc.strong.password>false</runtime.users.jdbc.strong.password>\n<runtime.users.jdbc.strong.password.min-length>8</runtime.users.jdbc.strong.password.min-length>');
    
    logger.info("Migration needs a restart of the application");
    actionData.setRequiresRestart(true);
}
