/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let userPopulations = "ametys-home://config/user-populations.xml"

let re = /<runtime\.users\.jdbc\.strong\.password\.requirements>((?:.|\r|\n)*?)<\/runtime\.users\.jdbc\.strong\.password\.requirements>/gm;

var restart = Ametys.utils.searchAndReplace(userPopulations, re, (match, $1) => {
    
    let reValue = /<value>(.*?)<\/value>/gm;
    
    let requirements = "",
        doneLowercase = false,
        doneUppercase = false,
        doneSpecials = false,
        doneNumbers = false;
        
    let val;
    while(val = reValue.exec($1))
    {
        let v = val[1];
        
        if (v == 'useLowercase')
        {
            requirements += "\n<runtime.users.jdbc.strong.password.min-lowercase>1</runtime.users.jdbc.strong.password.min-lowercase>";
            doneLowercase = true;
        }
        else if (v == 'useUppercase')
        {
            requirements += "\n<runtime.users.jdbc.strong.password.min-uppercase>1</runtime.users.jdbc.strong.password.min-uppercase>";
            doneUppercase = true;
        }
        else if (v == 'useNumbers')
        {
            requirements += "\n<runtime.users.jdbc.strong.password.min-numbers>1</runtime.users.jdbc.strong.password.min-numbers>";
            doneNumbers = true;
        }
        else if (v == 'useSpecial')
        {
            requirements += "\n<runtime.users.jdbc.strong.password.min-specials>1</runtime.users.jdbc.strong.password.min-specials>";
            doneSpecials = true;
        }
    }
    
    if (!doneLowercase)
    {
        requirements += "\n<runtime.users.jdbc.strong.password.min-lowercase>0</runtime.users.jdbc.strong.password.min-lowercase>";
    }
    if (!doneUppercase)
    {
        requirements += "\n<runtime.users.jdbc.strong.password.min-uppercase>0</runtime.users.jdbc.strong.password.min-uppercase>";
    }
    if (!doneNumbers)
    {
        requirements += "\n<runtime.users.jdbc.strong.password.min-numbers>0</runtime.users.jdbc.strong.password.min-numbers>";
    }
    if (!doneSpecials)
    {
        requirements += "\n<runtime.users.jdbc.strong.password.min-specials>0</runtime.users.jdbc.strong.password.min-specials>";
    }
    requirements += "\n<runtime.users.jdbc.strong.password.special-characters>!%&amp;@#$^*?_~</runtime.users.jdbc.strong.password.special-characters>";
    
    return match.replace(match, requirements);
    
});


// Migrate empty requirements 
re = /<runtime\.users\.jdbc\.strong\.password\.requirements\/>/gm;

restart = restart || Ametys.utils.searchAndReplace(userPopulations, re, (match, $1) => {
    
    let requirements = "";
    requirements += "\n<runtime.users.jdbc.strong.password.min-lowercase>0</runtime.users.jdbc.strong.password.min-lowercase>";
    requirements += "\n<runtime.users.jdbc.strong.password.min-uppercase>0</runtime.users.jdbc.strong.password.min-uppercase>";
    requirements += "\n<runtime.users.jdbc.strong.password.min-numbers>0</runtime.users.jdbc.strong.password.min-numbers>";
    requirements += "\n<runtime.users.jdbc.strong.password.min-specials>0</runtime.users.jdbc.strong.password.min-specials>";
    
    requirements += "\n<runtime.users.jdbc.strong.password.special-characters>!%&amp;@#$^*?_~</runtime.users.jdbc.strong.password.special-characters>";
    
    return match.replace(match, requirements);
        
});

// Restart only if the configuration was updated
actionConfiguration.setRequiresRestart(restart);
