/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let userPopulations = "ametys-home://config/user-populations.xml"

let containsFormCredentialProviders = Ametys.utils.contains(userPopulations, /<credentialProvider[^>]+modelId="org\.ametys\.core\.authentication\.FormBased"[^>]+>/g)
let containsFormResetParameter = Ametys.utils.contains(userPopulations, /(<runtime.authentication.form.display-reset-link)/g)

if (containsFormCredentialProviders && !containsFormResetParameter)
{
    Ametys.utils.searchAndReplace(userPopulations, 
        /(<credentialProvider[^>]+modelId="org\.ametys\.core\.authentication\.FormBased"[^>]+>)/g,
        '$1<runtime.authentication.form.display-reset-link>true</runtime.authentication.form.display-reset-link>');
    
    logger.info("Migration needs a restart of the application");
    actionData.setRequiresRestart(true);
}