/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 * Compute a version component for each sql table used by a user directory.
 * If two directories use the same table (highly improbable) only one version
 * will be computed. This allow the use of script that will fail on re-execution.
 * 
 * By creating a version for each table, we unsure to migrate table that belongs
 * to populations that were unavailable during a previous migration (because
 * we were in safe mode for exemple).
 *
 * The list of tables is computed by iterating on every user directory of every
 * population.
 */


const results = new java.util.HashMap();

const sqlDataSourceManager = Ametys.serviceManager.lookup(org.ametys.core.datasource.SQLDataSourceManager.ROLE);

const versionStorageEP = Ametys.serviceManager.lookup(org.ametys.core.migration.version.storage.VersionStorageExtensionPoint.ROLE);
const versionStorage = versionStorageEP.getExtension('sql');

const datasourcesIds = {};

const populations = Ametys.serviceManager.lookup('org.ametys.core.user.population.UserPopulationDAO').getUserPopulations(true);
for (let population of populations)
{
    const credentialProviders = population.getCredentialProviders();
    for (let credentialProvider of credentialProviders)
    {
        if (credentialProvider.getCredentialProviderModelId() == "org.ametys.core.authentication.FormBased")
        {
            const datasourceId = credentialProvider.getParameterValues().get("runtime.authentication.form.security.storage");
            
            // resolve the potential indirection due to the default datasource
            const actualDatasourceId = sqlDataSourceManager.getDataSourceDefinition(datasourceId).getId();
            datasourcesIds[actualDatasourceId] = true;
        }
    }
}

for (let datasourceId of Object.keys(datasourcesIds))
{
    const configuration = new org.ametys.core.migration.version.storage.SqlVersionStorage.SqlVersionConfiguration(datasourceId);
    const versions = versionStorage.getVersions(componentId, configuration, component);

    const dsDef = sqlDataSourceManager.getDataSourceDefinition(datasourceId);
    const dsKey = dsDef.getName();
  
    results.put(dsKey, {
        "id": `${componentId}_${datasourceId}`,
        "versions": versions,
        "componentId": componentId,
        "versionConfiguration": configuration,
        "additionalValues": {}
    });
}

return results;
