/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
const datasourceId = version.getStorageConfiguration().dataSource();

const connection = org.ametys.core.datasource.ConnectionHelper.getConnection(datasourceId);
const tableExists = org.ametys.core.script.SQLScriptHelper.tableExists(connection, "Users_FormConnectionFailed"); 
org.ametys.core.datasource.ConnectionHelper.cleanup(connection);

if (tableExists)
{
    // There is no versions but the table exists? probably due to RUNTIME-3790.. let's drop the table that does not contains important data
    SQL.update("Drop Table Users_FormConnectionFailed", datasourceId);
}
 