<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
			    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
			    xmlns:math="http://exslt.org/math"
			    xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
			    exclude-result-prefixes="math captcha">
    	
	<xsl:template name="captcha_impl">
        <xsl:param name="key-name"/>
        <xsl:param name="key-id"/>
        <xsl:param name="color"/>
        <xsl:param name="value-name"/>
        <xsl:param name="value-id"/>
        <xsl:param name="value-style"/>
        <xsl:param name="value-class"/>
        <xsl:param name="placeholder"/>
        <xsl:param name="placeholder-i18n"/>
        <xsl:param name="placeholder-catalogue"/>
        <xsl:param name="image-id"/>
        <xsl:param name="image-alt"/>
        <xsl:param name="image-alt-i18n"/>
        <xsl:param name="image-alt-catalogue"/>
        <xsl:param name="image-style"/>
        <xsl:param name="image-class"/>
        <xsl:param name="image-width"/>
        <xsl:param name="image-height"/>
        <xsl:param name="allow-refresh"/>
        <xsl:param name="js-funcname-torefresh"/>
        <xsl:param name="plugin"/>
        <xsl:param name="aria-invalid"/>
        <xsl:param name="aria-describedby"/>
        
        <input type="hidden" name="{$key-name}" id="{$key-id}"/>
        
        <input type="text" name="{$value-name}" maxlength="6" id="{$value-id}" style="{$value-style}" class="{$value-class}">
             <xsl:if test="$placeholder != ''">
                <xsl:attribute name="placeholder">
                    <xsl:if test="$placeholder-i18n and $placeholder-catalogue != ''">
                        <xsl:value-of select="$placeholder-catalogue"/>
                        <xsl:text>:</xsl:text>
                    </xsl:if>
                    <xsl:value-of select="$placeholder"/>
                </xsl:attribute>
                <xsl:if test="$placeholder-i18n"><xsl:attribute name="i18n:attr">placeholder</xsl:attribute></xsl:if>
            </xsl:if>
            <xsl:if test="$aria-invalid = true()">
                <xsl:attribute name="aria-invalid">true</xsl:attribute>
                
                <xsl:if test="$aria-describedby != ''">
                    <xsl:attribute name="aria-describedby"><xsl:value-of select="$aria-describedby"/></xsl:attribute>
                </xsl:if>
            </xsl:if>
        </input>
        
        <div class="captcha">
            <img style="{$image-style}" class="{$image-class}" src="" id="{$image-id}">
                <xsl:attribute name="alt">
                    <xsl:if test="$image-alt-i18n and $image-alt-catalogue != ''">
                        <xsl:value-of select="$image-alt-catalogue"/>
                        <xsl:text>:</xsl:text>
                    </xsl:if>
                    <xsl:value-of select="$image-alt"/>
                </xsl:attribute>
                <xsl:if test="$image-alt-i18n"><xsl:attribute name="i18n:attr">alt</xsl:attribute></xsl:if>
            </img>
        
            <xsl:if test="$allow-refresh = true()">
                <button type="button" title="plugin.core-impl:PLUGINS_CORE_CAPTCHA_REFRESH_ALT" i18n:attr="title" 
                        class="captcha-refresh-btn" 
                        onclick="{$js-funcname-torefresh}(this, false); return false;">
                    <span><i18n:text i18n:key="PLUGINS_CORE_CAPTCHA_REFRESH" i18n:catalogue="plugin.core-impl"/></span>
                </button>
            </xsl:if>
            <div class="captcha-end"></div>
        </div>
       
       <script type="text/javascript">     
            function <xsl:value-of select="$js-funcname-torefresh"/>(focusNow)
            {
                var newId = "DYNAMIC-" + new Date().getTime() + (''+Math.random()).replace(/\./g, '');
            
                var oldId = document.getElementById("<xsl:value-of select="$key-id"/>").value;
                document.getElementById("<xsl:value-of select="$key-id"/>").value = newId;
                document.getElementById("<xsl:value-of select="$value-id"/>").value = "";
                document.getElementById("<xsl:value-of select="$image-id"/>").src = "<xsl:value-of select="$uri-prefix"/>/plugins/<xsl:value-of select="$plugin"/>/captcha/core-impl/jcaptcha/" + newId + "/image.png?cancelledKey=" + oldId + "&amp;width=<xsl:value-of select="$image-width"/>" + "&amp;height=<xsl:value-of select="$image-height"/>" + "&amp;color=<xsl:value-of select="$color"/>";
                
                if (focusNow == true)
                {
                    try
                    {
                        document.getElementById("<xsl:value-of select="$value-id"/>").focus();
                    }
                    catch(e)
                    {
                    }
                } 
            }
        </script>
        
        <!-- Keep the bellow comment -->
        <xsl:comment>Those 2 scripts are separated to ensure write is done and flushed before the getElementId occures</xsl:comment>    
        <script type="text/javascript">
            <xsl:value-of select="$js-funcname-torefresh"/>(false);
        </script>
    </xsl:template>

</xsl:stylesheet>
