<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
			    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
			    xmlns:math="http://exslt.org/math"
			    xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
			    exclude-result-prefixes="math captcha">
    
    <xsl:template name="captcha_impl">
        <xsl:param name="value-name"/>
        <xsl:param name="js-funcname-torefresh"/>
        <xsl:param name="aria-invalid"/> <!-- unsupported by this implementation -->
        <xsl:param name="aria-describedby"/> <!-- unsupported by this implementation -->
        
        <xsl:variable name="captcha-id"><xsl:value-of select="concat('captcha', substring-after(math:random(), '.'))"/></xsl:variable>
        <xsl:variable name="public-key"><xsl:value-of select="ametys:config('runtime.captcha.recaptcha.enterprise.sitekey')" /></xsl:variable>
        
        <input type="hidden" id="{$captcha-id}" name="{$value-name}" />
        
        <!-- Load recaptcha script -->
        <script id="g-recaptcha-script_{$captcha-id}" src="https://www.google.com/recaptcha/enterprise.js?render={$public-key}"/>
        <script type="text/javascript">
        
            function generate_<xsl:value-of select="$captcha-id"/>()
            {
                grecaptcha.enterprise.ready(async () => {
                const token = await grecaptcha.enterprise.execute('<xsl:value-of select='$public-key'/>');
                document.getElementById("<xsl:value-of select="$captcha-id"/>").value = token;
                });
            }
            
            generate_<xsl:value-of select="$captcha-id"/>();
            
            function <xsl:value-of select="$js-funcname-torefresh"/>()
            {
                generate_<xsl:value-of select="$captcha-id"/>();
            }
        </script>
    </xsl:template>
</xsl:stylesheet>
