<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
			    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
			    xmlns:math="http://exslt.org/math"
			    xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
			    exclude-result-prefixes="math captcha">
    
    <xsl:template name="captcha_impl">
        <xsl:param name="key-name"/>
        <xsl:param name="key-id"/>
        <xsl:param name="value-name"/>
        <xsl:param name="value-id"/>
        <xsl:param name="recaptcha-theme"/>
        <xsl:param name="recaptcha-size"/>
        <xsl:param name="js-funcname-torefresh"/>
        <xsl:param name="aria-invalid"/> <!-- unsupported by this implementation -->
        <xsl:param name="aria-describedby"/> <!-- unsupported by this implementation -->
        
        <xsl:variable name="captcha-id"><xsl:value-of select="concat('captcha', substring-after(math:random(), '.'))"/></xsl:variable>
        <xsl:variable name="public-key"><xsl:value-of select="ametys:config('runtime.captcha.recaptcha.publickey')" /></xsl:variable>
        
        <input type="hidden" name="{$key-name}" id="{$key-id}"/>
        <input type="hidden" name="{$value-name}" id="{$value-id}"/>
        <div class="g-recaptcha" id="{$captcha-id}"></div>
        
        <script type="text/javascript">
            function loadValueToSend_<xsl:value-of select="$captcha-id"/>(value) {
                document.getElementById("<xsl:value-of select="$value-id"/>").value = value;
            }
            var widgetIds = [];
            
            function ReCaptchaCallback_<xsl:value-of select='$captcha-id'/> ()
            {
                recaptchaLoaded = true;
                for (var i = 0; i &lt; recaptchaFieldsToLoad.length; i++)
                {
                    var resetId = grecaptcha.render(recaptchaFieldsToLoad[i].captchaId, {
                        'sitekey' : '<xsl:value-of select='$public-key'/>',
                        'callback' : recaptchaFieldsToLoad[i].callback, 
                        'theme' : recaptchaFieldsToLoad[i].theme,
                        'size' : recaptchaFieldsToLoad[i].size,
                        'tabindex' : "1"
                    });
                widgetIds[recaptchaFieldsToLoad[i].captchaId] = resetId;
                }
            }
            
            if (typeof recaptchaLoaded == 'undefined')
            {
                // The recaptcha script was never loaded
                recaptchaLoaded = false;
                recaptchaFieldsToLoad = [{
                    'captchaId' : "<xsl:value-of select='$captcha-id'/>",
                    'callback' : loadValueToSend_<xsl:value-of select='$captcha-id'/> ,
                    'theme' : '<xsl:value-of select="$recaptcha-theme" />',
                    'size' : '<xsl:value-of select="$recaptcha-size" />',
                }];
                document.write("&lt;script src=\"https://www.google.com/recaptcha/api.js?onload=ReCaptchaCallback_<xsl:value-of select='$captcha-id'/>&amp;render=explicit\" async defer&gt;&lt;/script&gt;");
            }
            else if (recaptchaLoaded == false)
            {
                // The recaptcha script is loading but not ready.
                recaptchaFieldsToLoad.push({
                    'captchaId' : "<xsl:value-of select='$captcha-id'/>",
                    'callback' : loadValueToSend_<xsl:value-of select='$captcha-id'/> ,
                    'theme' : '<xsl:value-of select="$recaptcha-theme" />',
                    'size' : '<xsl:value-of select="$recaptcha-size" />'
                })
            }
            else
            {
                // the recaptcha script is loaded and ready
                var resetId = grecaptcha.render("<xsl:value-of select='$captcha-id'/>", {
                    'sitekey' : '<xsl:value-of select='$public-key'/>',
                    'callback' : loadValueToSend_<xsl:value-of select='$captcha-id'/>,
                    'theme' : '<xsl:value-of select="$recaptcha-theme" />',
                    'size' : '<xsl:value-of select="$recaptcha-size" />'
                });
                widgetIds[<xsl:value-of select='$captcha-id'/>] = resetId;
            }
            
            function <xsl:value-of select="$js-funcname-torefresh"/>(focusNow)
            {
                grecaptcha.reset(widgetIds["<xsl:value-of select='$captcha-id'/>"]);
            }
            
        </script>
        
    </xsl:template>
</xsl:stylesheet>
