<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys math">
         
    <xsl:template name="vuejs-head">
        <xsl:param name="component"/>
        <xsl:param name="location"/>
        <xsl:param name="load-styles" select="true()"/>
        
        <xsl:if test="not(ametys:requestParameter('vueserve') = $component)">
            <script type="text/javascript" src="{$location}/main.umd.min.js"/>
            <xsl:if test="$load-styles">
                <link rel="stylesheet" type="text/css" href="{$location}/style.min.css"/>
            </xsl:if>
	    </xsl:if>
    </xsl:template>

    <xsl:template name="vuejs">
        <xsl:param name="component"/>
        <xsl:param name="uniqueId" select="concat('vuejs-component-', substring-after(math:random(), '.'))"/>
        <xsl:param name="config">{}</xsl:param>
        
        <div id="{$uniqueId}">
        </div>
        
        <xsl:if test="ametys:requestParameter('vueserve') = $component">
            <xsl:variable name="devserver">
                <xsl:choose>
                    <xsl:when test="ametys:requestParameter('devserver') != ''"><xsl:value-of select="ametys:requestParameter('devserver')"/></xsl:when>
                    <xsl:otherwise>localhost:5173</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <script type="module" src="http://{$devserver}/@vite/client"/>
            <script type="module" src="http://{$devserver}/src/main.js"/>
        </xsl:if>
        <script type="module">
            window['vue-<xsl:value-of select="$component"/>-run']("#<xsl:value-of select="$uniqueId"/>", <xsl:copy-of select="$config"/>);
        </script>
    </xsl:template>
</xsl:stylesheet> 
