<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:uri="org.ametys.core.util.URIUtils"
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:captcha="org.ametys.core.captcha.CaptchaHelper">
    
    <xsl:import href="plugin:core://stylesheets/helper/common.xsl"/>    
    
    <xsl:param name="authFailure" select="ametys:requestParameter('authFailure')"/><!-- true to display a login failed message -->
    <xsl:param name="login" select="ametys:requestParameter('login')"/><!-- the login previously submitted -->
    <xsl:param name="tooManyAttempts" select="ametys:requestParameter('tooManyAttempts')"/><!-- true when authentication failed due to too many attempts with that login -->
    <xsl:param name="cookieFailure" select="ametys:requestParameter('cookieFailure')"/><!-- true when the remember me function failed to authenticate -->
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    <xsl:variable name="uri-prefix" select="ametys:uriPrefix()"/>
    <xsl:variable name="contextPath" select="ametys:uriPrefix(false())"/>

    <!-- MAIN LOGIN TEMPLATE -->
            
    <xsl:template name="login">
        <div class="login">
            <xsl:call-template name="login-user-populations-standalone"/>
	        
	        <xsl:call-template name="login-credential-providers"/>
	        
	        <xsl:call-template name="login-multifactor-authentication"/>
	    </div>
	</xsl:template>

    <xsl:template name="login-user-populations-standalone">
        <xsl:if test="(not(/LoginScreen/CredentialProviders/CredentialProvider) or (count(LoginScreen/CredentialProviders/CredentialProvider) = 1 and /LoginScreen/CredentialProviders/CredentialProvider[not(@isForm = 'true')])) and not(/LoginScreen/LoginForm/MultifactorAuthentication)">
	        <div class="login-part">
	            <form method="post">
	                <div class="login-inner login-user-populations-standalone">
	                    <input type="hidden" name="CredentialProviderIndex" value="-1"/>
	                
                        <xsl:call-template name="login-user-populations"/>

                        <xsl:call-template name="login-user-populations-submit"/>
                    </div>
                </form>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- CREDENTIAL PROVIDERS -->
    
    <xsl:template name="login-credential-providers">
        <xsl:if test="/LoginScreen/CredentialProviders/CredentialProvider and not(/LoginScreen/LoginForm/MultifactorAuthentication)">
            <xsl:choose>
		        <xsl:when test="not((count(LoginScreen/CredentialProviders/CredentialProvider) = 1 and /LoginScreen/CredentialProviders/CredentialProvider[not(@isForm = 'true')]))">
			        <div class="login-part">
				        <xsl:for-each select="/LoginScreen/CredentialProviders/CredentialProvider">
				            <xsl:if test="position() != 1">
				                <div class="login-part-credentialproviders-separator"><div class="textin"><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SEPARATOR" i18n:catalogue="plugin.core-ui" /></div></div>
				            </xsl:if>
				            
			                <form method="post">
					            <input type="hidden" name="CredentialProviderIndex" value="{@index}"/>
					            <xsl:choose>
					                <xsl:when test="@isForm = 'true' and (count(/LoginScreen/CredentialProviders/CredentialProvider[@isForm = 'true']) = 1 or @selected = 'true')">
					                    <xsl:call-template name="login-form"/>
					                </xsl:when>
		                            <xsl:when test="@isNewWindowRequired = 'false'">
		                                <xsl:call-template name="login-credential-provider-reload"/>
		                            </xsl:when>
					                <xsl:otherwise>
					                    <xsl:call-template name="login-credential-provider-popup"/>
					                </xsl:otherwise>
					            </xsl:choose>
					        </form>
		    	        </xsl:for-each>
		    	        
		                <xsl:call-template name="login-back"/>
				    </div>
				</xsl:when>
				<xsl:when test="/LoginScreen/CredentialProviders/CredentialProvider[@isNewWindowRequired = 'true']">
				    <script type="text/javascript">
				        <xsl:call-template name="login-credential-provider-script"/>
				    </script>
				</xsl:when>
				<xsl:otherwise>
				    <!-- We are in a population with a single blocking CP that does not require a new window... this should not happen -->
				</xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    
    <xsl:template name="login-credential-provider-reload">
        <div class="login-inner login-credential-provider">
            <button type="submit" style="background-color: #{color};">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_CORE_AUTHENTICATION_BLOCKING_CONNECTION_LABEL" i18n:catalogue="plugin.core-impl"/>
                    <i18n:param>
		                <xsl:choose>
		                    <xsl:when test="additionalLabel"><xsl:value-of select="additionalLabel"/></xsl:when>
		                    <xsl:otherwise><xsl:value-of select="label"/></xsl:otherwise>
		                </xsl:choose>
                    </i18n:param>
                </i18n:translate>
                <span class="glyph {iconGlyph}"></span>
            </button>
        </div>
    </xsl:template>
    
    <xsl:template name="login-credential-provider-popup">
        <div class="login-inner login-credential-provider">
            <button style="background-color: #{color};">
                <xsl:attribute name="onclick"><xsl:call-template name="login-credential-provider-script"><xsl:with-param name="index" select="@index"/></xsl:call-template> return false;</xsl:attribute>
            
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_CORE_AUTHENTICATION_BLOCKING_CONNECTION_LABEL" i18n:catalogue="plugin.core-impl"/>
                    <i18n:param>
                        <xsl:choose>
                            <xsl:when test="additionalLabel"><xsl:value-of select="additionalLabel"/></xsl:when>
                            <xsl:otherwise><xsl:value-of select="label"/></xsl:otherwise>
                        </xsl:choose>
                    </i18n:param>
                </i18n:translate>
                <span class="glyph {iconGlyph}"></span>
            </button>
        </div>
    </xsl:template>
    
    <xsl:template name="login-credential-provider-script">
        <xsl:param name="index">0</xsl:param>
        
        try { window.open("<xsl:value-of select="ametys:uriPrefix()"/>/plugins/core/authenticate/<xsl:value-of select="$index"/>?contexts=<xsl:value-of select="uri:encodePath(/LoginScreen/contexts)"/>", null, "height: ;") } catch (e) { }
    </xsl:template>
    
    
    <!-- BACK -->
    
    <xsl:template name="login-back">
        <xsl:if test="not(/LoginScreen/UserPopulations)">
            <form method="post">
                <div class="login-inner login-back">
                    <input type="hidden" name="UserPopulation" value=""/>
                    <button type="submit"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_BACK' i18n:catalogue='plugin.core-ui'/></button>
                </div>
            </form>
        </xsl:if>
    </xsl:template>
    
    <!-- FORM -->
    
    <xsl:template name="login-form">
        <div class="login-inner login-form">
            <xsl:if test="/LoginScreen/UserPopulations/@size > 1">
                <xsl:call-template name="login-user-populations"/>
            </xsl:if>

            <xsl:call-template name="login-form-inputs"/>

            <xsl:call-template name="login-form-submit"/>
        </div>
    </xsl:template>

    <!-- USERS POPULATIONS -->

    <xsl:template name="login-user-populations">
        <xsl:param name="populations" select="/LoginScreen/UserPopulations"/>
    
        <xsl:variable name="public" select="$populations/@public = 'true'"/>
        <xsl:variable name="list" select="$public = true() and $populations/@size > 1"/>

        <xsl:if test="$public = false() or $list = true()">
            <xsl:call-template name="login-user-populations-part">
                <xsl:with-param name="public" select="$public = true()"/>
                <xsl:with-param name="populations" select="$populations"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="login-user-populations-part">
        <xsl:param name="public"/>
        <xsl:param name="populations" select="/LoginScreen/UserPopulations"/>

        <div class="login-user-populations">
             <xsl:if test="$populations/@invalid = 'true'">
                 <div class="error">
                     <i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_INVALID_POPULATION" i18n:catalogue="plugin.core-ui"/>
                 </div>
             </xsl:if>
             
	        <xsl:choose>
	            <xsl:when test="$public = false()">
	                <xsl:call-template name="login-user-populations-select">
                        <xsl:with-param name="populations" select="$populations"/>
                    </xsl:call-template>
	            </xsl:when>
	            <xsl:otherwise>
	                <xsl:call-template name="login-user-populations-input">
	                   <xsl:with-param name="populations" select="$populations"/>
                    </xsl:call-template>
                </xsl:otherwise>
	        </xsl:choose>
	   </div>
    </xsl:template>

    <xsl:template name="login-user-populations-input">
        <xsl:param name="populations" select="/LoginScreen/UserPopulations"/>
        
        <xsl:call-template name="login-user-populations-input-wrapper">
            <xsl:with-param name="placeholder">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_POPULATION_PLACEHOLDER</xsl:with-param>
            <xsl:with-param name="hint">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_POPULATION_HINT</xsl:with-param>
            <xsl:with-param name="populations" select="$populations"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="login-user-populations-input-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>
        <xsl:param name="populations" select="/LoginScreen/UserPopulations"/>
        
        <div class="login-input-wrapper login-input-wrapper-userpopulation login-input-wrapper-userpopulation-input">
        	<xsl:call-template name="login-user-populations-input-label-internal" />
        	<div class="input">
		        <input type="text" id="UserPopulation" name="UserPopulation" autofocus="true" required="" aria-required="true" value="{/LoginScreen/UserPopulations/@currentValue}">
		            <xsl:if test="$placeholder != ''">
		                <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
		                <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
		            </xsl:if>
		        </input>
		        <xsl:choose>
			        <xsl:when test="not($populations/@currentValue)">
  			            <script type="text/javascript">
			                if (localStorage)
			                {
			                    var input = document.getElementById("UserPopulation"); 
			                    input.value = localStorage.getItem("DefaultUserPopulation");
			                    input.onchange = function() { localStorage.setItem("DefaultUserPopulation", this.value); }
		                    }
			            </script> 
			        </xsl:when>
			        <xsl:otherwise>
			            <script type="text/javascript">
                            if (localStorage)
                            {
			                   localStorage.setItem("DefaultUserPopulation", document.getElementById("UserPopulation").value);
			                   input.onchange = function() { localStorage.setItem("DefaultUserPopulation", this.value); }
		                    }
			            </script>
			        </xsl:otherwise>
		        </xsl:choose>
	        </div>
	    </div>
    </xsl:template>
    
    <xsl:template name="login-user-populations-input-label-internal">
		<div class="label">
			<label for="UserPopulation"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_POPULATION_LABEL' i18n:catalogue='plugin.core-ui'/></label>
		</div>
	</xsl:template>
    
    <xsl:template name="login-user-populations-select">
        <xsl:param name="populations" select="/LoginScreen/UserPopulations"/>
        
        <xsl:call-template name="login-user-populations-select-wrapper">
            <xsl:with-param name="placeholder">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_POPULATION_PLACEHOLDER</xsl:with-param>
            <xsl:with-param name="hint">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_POPULATION_HINT</xsl:with-param>
            <xsl:with-param name="populations" select="$populations"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="login-user-populations-select-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>
        <xsl:param name="populations" select="/LoginScreen/UserPopulations"/>
        
        <div class="login-input-wrapper login-input-wrapper-userpopulation login-input-wrapper-userpopulation-select">
	            <xsl:call-template name="login-user-populations-select-label-internal"/>
	            <div class="select">
	            	<xsl:if test="$placeholder != ''">
		                <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
		                <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
		            </xsl:if>
	            	<xsl:call-template name="login-user-populations-select-internal">
                        <xsl:with-param name="populations" select="$populations"/>
                    </xsl:call-template>
	            </div>
        </div>
	</xsl:template>
	
	<xsl:template name="login-user-populations-select-label-internal">
		<div class="label">
			<label for="Population"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_POPULATION_LABEL' i18n:catalogue='plugin.core-ui'/></label>
		</div>
	</xsl:template>
	
    <xsl:template name="login-user-populations-select-internal">
	        <xsl:param name="populations" select="/LoginScreen/UserPopulations"/>
            
            <select id="Population" name="UserPopulation" autofocus="true" required="" aria-required="true">
	            <xsl:for-each select="$populations/UserPopulation">
	                <xsl:sort select="label"/>
	               
	                <option value='{@id}'>
	                    <xsl:if test="../@currentValue = @id"><xsl:attribute name="selected">selected</xsl:attribute></xsl:if>    
	                    <xsl:copy-of select="label" />
	                </option>
	            </xsl:for-each>
	        </select>
	        <xsl:if test="not($populations/@currentValue)">
		        <script type="text/javascript">
		            var cls = ' login-input-wrapper-userpopulation-select-empty';
		            
		            var select = document.getElementById('Population');
                    select.parentNode.parentNode.className += cls;
		            select.selectedIndex = -1;
		            select.onchange = function() {
	                    if (localStorage)
	                    { 
	                        localStorage.setItem("DefaultUserPopulation", select.value);
	                    }
		            
		               this.parentNode.parentNode.className = this.parentNode.parentNode.className.replace(cls, '');
		               if (select.selectedIndex == -1)
		               {
		                  this.parentNode.parentNode.className += cls;
		               }
		            }
		            
		            if (localStorage)
		            { 
		                select.value = localStorage.getItem("DefaultUserPopulation");
		                select.onchange();
		            }
		        
		            window.addEventListener('load', function() {
  	                    if (select.selectedIndex != -1)
  	                    {
  	                        // BACK was done
			                select.onchange();
			            }
			        });
		        </script>
		    </xsl:if>
    </xsl:template>

    <xsl:template name="login-user-populations-submit">
        <button type="submit"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_CONTINUE' i18n:catalogue='plugin.core-ui'/></button>
    </xsl:template>

    <!-- FORM -->
    
    <xsl:template name="login-form-submit">
        <button type="submit">
            <i18n:translate>
                <i18n:text i18n:key="PLUGINS_CORE_AUTHENTICATION_BLOCKING_CONNECTION_LABEL" i18n:catalogue="plugin.core-impl"/>
                <i18n:param>
                    <xsl:choose>
                        <xsl:when test="/LoginScreen/LoginForm/additionalLabel"><xsl:value-of select="/LoginScreen/LoginForm/additionalLabel"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SUBMIT' i18n:catalogue='plugin.core-ui'/></xsl:otherwise>
                    </xsl:choose>
                </i18n:param>
            </i18n:translate>
        </button>
    </xsl:template>
    
    <xsl:template name="login-form-inputs">
    	<xsl:if test="/LoginScreen/LoginForm">
		    <div class="login-form-inputs">
		        <xsl:call-template name="login-form-inputs-errors"/>
		         
		        <xsl:call-template name="login-form-inputs-username"/>
		        
                <xsl:call-template name="login-form-inputs-password"/>

                <xsl:if test="/LoginScreen/LoginForm/useCaptcha = 'true'">
                    <xsl:call-template name="login-form-inputs-captcha"/>
                </xsl:if>
                
                <xsl:if test="/LoginScreen/LoginForm/displayForgottenLink = 'true'">
                    <xsl:call-template name="login-form-inputs-forgotten"/>
                </xsl:if>
                
            	<xsl:if test="/LoginScreen/LoginForm/rememberMe = 'true'">
                    <xsl:call-template name="login-form-inputs-rememberme"/>
            	</xsl:if>
			</div>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-errors">
        <xsl:if test="/LoginScreen/LoginForm/showErrors = 'true' and $authFailure = 'true'">
            <div class="error">
                <xsl:choose>
                    <xsl:when test="$tooManyAttempts = 'true'"><i18n:text i18n:key="{captcha:getFailedI18NKey()}" i18n:catalogue="{captcha:getFailedI18NCatalog()}"/></xsl:when>
                    <xsl:when test="/LoginScreen/LoginForm/useCaptcha = 'true'"><i18n:text i18n:key="{captcha:getFailedI18NKey()}" i18n:catalogue="{captcha:getFailedI18NCatalog()}"/></xsl:when>
                    <xsl:when test="not($cookieFailure = 'true')"><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_AUTH_FAILURE" i18n:catalogue="plugin.core-ui"/></xsl:when>
                </xsl:choose>
            </div>
        </xsl:if>
    </xsl:template>

    <xsl:template name="login-form-inputs-forgotten">
        <xsl:call-template name="login-form-inputs-forgotten-internal">
            <xsl:with-param name="label"><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_PASSWORD_FORGOTTEN" i18n:catalogue="plugin.core-ui"/></xsl:with-param>
            <xsl:with-param name="url"><xsl:value-of select="ametys:uriPrefix()"/>/plugins/core/reset-password.html?contexts=<xsl:value-of select="/LoginScreen/contexts"/></xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-forgotten-internal">
        <xsl:param name="label"/>
        <xsl:param name="url"/>
    
        <div class="login-link-wrapper-forgotten">
            <a href="{$url}"><xsl:copy-of select="$label"/></a>
        </div>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-username">
    
        <xsl:variable name="placeholder">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/allowLoginByEmail = 'true'">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_LOGIN_OR_EMAIL_PLACEHOLDER</xsl:when>
                <xsl:otherwise>plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_LOGIN_PLACEHOLDER</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="hint">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/allowLoginByEmail = 'true'">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_LOGIN_OR_EMAIL_HINT</xsl:when>
                <xsl:otherwise>plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_LOGIN_HINT</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:call-template name="login-form-inputs-username-wrapper">
            <xsl:with-param name="placeholder" select="$placeholder"/>
            <xsl:with-param name="hint" select="$hint"/>
        </xsl:call-template>
    </xsl:template>    
    
    <xsl:template name="login-form-inputs-username-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>

        <xsl:variable name="autocomplete">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/autocomplete = 'true'">username</xsl:when>
                <xsl:otherwise>off</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div class="login-input-wrapper login-input-wrapper-username">
        	<xsl:call-template name="login-form-inputs-username-label-internal" />
        	<div class="input">
	            <input type="text" name="Username" id="Username" autocomplete="{$autocomplete}" autofocus="true" value="{$login}" onFocus="this.select();" required="" aria-required="true">
	                <xsl:if test="$placeholder != ''">
	                    <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
	                    <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
	                </xsl:if>
	            </input>
	        </div>
        </div>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-username-label-internal">
    	<div class="label">
       		<label for="Username"><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_LOGIN" i18n:catalogue="plugin.core-ui"/></label>
       	</div>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-password">
        <xsl:call-template name="login-form-inputs-password-wrapper">
            <xsl:with-param name="placeholder">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_PASSWORD_PLACEHOLDER</xsl:with-param>
            <xsl:with-param name="hint">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_PASSWORD_HINT</xsl:with-param>
        </xsl:call-template>
    </xsl:template>    
    <xsl:template name="login-form-inputs-password-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>
        <xsl:param name="id">Password</xsl:param>
        <xsl:param name="name">Password</xsl:param>
        
        <xsl:variable name="autocomplete">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/autocomplete = 'true'">current-password</xsl:when>
                <xsl:otherwise>off</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        
        <div class="login-input-wrapper login-input-wrapper-password">
        	<xsl:call-template name="login-form-inputs-password-label-internal">
                <xsl:with-param name="id" select="$id"/>
            </xsl:call-template>
        	<div class="input">
		        <input type="password" name="{$name}" id="{$id}" autocomplete="{$autocomplete}" required="" aria-required="true">
		            <xsl:if test="$placeholder != ''">
		                <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
		                <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
		            </xsl:if>
		        </input>
                <xsl:call-template name="login-form-inputs-password-toggle-visibility">
                    <xsl:with-param name="id" select="$id"/>
                </xsl:call-template>
		    </div>
	    </div>
    </xsl:template>  
    
    <xsl:template name="login-form-inputs-password-toggle-visibility">
        <xsl:param name="id">Password</xsl:param>
        
        <button class="login-password-toggle-visibility" type="button" tabindex="0" id="{$id}-toggle-visibility" title="plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SHOW_PASSWORD_TITLE" i18n:attr="title">
            <span><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SHOW_PASSWORD" i18n:catalogue="plugin.core-ui"/></span>
        </button>
        <script type="text/javascript">
            document.getElementById('<xsl:value-of select="$id"/>-toggle-visibility').onclick = function () {
                let pwInput = document.getElementById('<xsl:value-of select="$id"/>');
                if (pwInput.type === "password") 
                {
                    // show password
                    pwInput.type = "text";
                    this.getElementsByTagName('span')[0].innerHTML = "<i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_HIDE_PASSWORD" i18n:catalogue="plugin.core-ui"/>";
                    this.setAttribute("title", "<i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_HIDE_PASSWORD_TITLE" i18n:catalogue="plugin.core-ui"/>");
                    this.classList.add("login-password-visibility-hide");
                } 
                else 
                {
                    // hide password
                    pwInput.type = "password";
                    this.getElementsByTagName('span')[0].innerHTML = "<i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SHOW_PASSWORD" i18n:catalogue="plugin.core-ui"/>";
                    this.setAttribute("title", "<i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SHOW_PASSWORD_TITLE" i18n:catalogue="plugin.core-ui"/>");
                    this.classList.remove("login-password-visibility-hide");
                }
            }
            
            document.getElementById('<xsl:value-of select="$id"/>-toggle-visibility').closest('form').onsubmit = function() {
                let pwInput = document.getElementById('<xsl:value-of select="$id"/>');
                let toggleBtn = document.getElementById('<xsl:value-of select="$id"/>-toggle-visibility');
                if (pwInput.type === "text") 
                {
                    // back to password type before submit
                    pwInput.type = "password";
                    toggleBtn.getElementsByTagName('span')[0].innerHTML = "<i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SHOW_PASSWORD" i18n:catalogue="plugin.core-ui"/>";
                    toggleBtn.setAttribute("title", "<i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SHOW_PASSWORD_TITLE" i18n:catalogue="plugin.core-ui"/>");
                    toggleBtn.classList.remove("login-password-visibility-hide");
                }
                return true;
            };
        </script>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-password-label-internal">
        <xsl:param name="id" select="Password"/>
        
    	<div class="label">
       		<label for="{$id}"><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_PASSWORD" i18n:catalogue="plugin.core-ui"/></label>
       	</div>
    </xsl:template>  
    
    <xsl:template name="login-form-inputs-rememberme">
        <xsl:call-template name="login-form-inputs-rememberme-internal">
            <xsl:with-param name="label">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_PERSIST</xsl:with-param>
        </xsl:call-template>
    </xsl:template>    
    <xsl:template name="login-form-inputs-rememberme-internal">
        <xsl:param name="label"/>
        
         <div class="login-input-wrapper login-input-wrapper-rememberme">
             <input type="checkbox" name="rememberMe" id="rememberMe" value="true"/>
             <xsl:if test="$label != ''">
                <label for="rememberMe"><i18n:text i18n:key="{substring-after($label, ':')}" i18n:catalogue="{substring-before($label, ':')}"/></label>
             </xsl:if>
         </div>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-captcha">
        <xsl:call-template name="login-form-inputs-captcha-internal">
            <xsl:with-param name="placeholder">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_CAPTCHA_PLACEHOLDER</xsl:with-param>
            <xsl:with-param name="hint">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_CAPTCHA_HINT</xsl:with-param>
        </xsl:call-template>
    </xsl:template>    
    <xsl:template name="login-form-inputs-captcha-label-internal">
        <xsl:if test="captcha:requiresUserInteraction()">
            <div class="label">
                <label for="CaptchaKey"><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_CAPTCHA" i18n:catalogue="plugin.core-ui"/></label>
            </div>
        </xsl:if>
    </xsl:template>
    <xsl:template name="login-form-inputs-captcha-internal">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>
        
        <div class="login-input-wrapper login-input-wrapper-captcha login-input-wrapper-captcha-{captcha:getCaptchaType()}">
            <xsl:call-template name="login-form-inputs-captcha-label-internal" />
            <div class="input">
		        <xsl:call-template name="captcha">
		            <xsl:with-param name="key-name" select="'CaptchaKey'"/>
		
		            <xsl:with-param name="value-name" select="'Captcha'"/>
		            <xsl:with-param name="value-id" select="concat('captcha-', $uniqueId)"/>
		            <xsl:with-param name="value-class">captcha</xsl:with-param>
		
		            <xsl:with-param name="image-alt"/>
		            <xsl:with-param name="image-alt-i18n" select="false()"/>
		            <xsl:with-param name="image-class">captcha-image</xsl:with-param>
		            
		            <xsl:with-param name="image-height">50</xsl:with-param>
		            <xsl:with-param name="image-width">160</xsl:with-param>
		            
		            <xsl:with-param name="placeholder" select="substring-after($placeholder, ':')"/>
		            <xsl:with-param name="placeholder-i18n" select="true()"/>
		            <xsl:with-param name="placeholder-catalogue" select="substring-before($placeholder, ':')"/>
		        </xsl:call-template>
		    </div> 
	    </div>
    </xsl:template>
    
    <!-- MULTIFACTOR AUTHENTICATION -->
    
    <xsl:template name="login-multifactor-authentication">
        <xsl:if test="/LoginScreen/LoginForm/MultifactorAuthentication">
            <div class="login-part">
                <form method="post">
                    <div class="login-inner login-multifactor-authentication">
                        <input type="hidden" name="CredentialProviderIndex" value="{/LoginScreen/CredentialProviders/CredentialProvider[@selected='true']/@index}"/>
                        <input type="hidden" name="MultifactorAuthenticationMode" id="MultifactorAuthenticationMode" value="{/LoginScreen/LoginForm/MultifactorAuthentication/@mode}"/>
                        
                        <xsl:choose>
                            <xsl:when test="/LoginScreen/LoginForm/MultifactorAuthentication/@mode = 'EMAIL'">
                                <xsl:call-template name="login-mfa-email-intro"/>
                                
                                <xsl:call-template name="login-mfa-email-send-code"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="login-mfa-otpapp-intro"/>
                                
                                <xsl:call-template name="login-mfa-otpapp-send-code"/>
                            </xsl:otherwise>
                        </xsl:choose>

                        <xsl:call-template name="login-mfa-code"/>
                        
                        <xsl:call-template name="login-mfa-code-submit"/>
                    </div>
                </form>
                
                <xsl:call-template name="login-mfa-back"/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="login-mfa-email-intro">
        <div class="intro">
            <div class="textin">
                <p>
	                <i18n:translate>
	                    <i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_EMAIL_INTRO" i18n:catalogue="plugin.core-ui"/>
	                    <i18n:param><xsl:value-of select="/LoginScreen/LoginForm/MultifactorAuthentication/@email"/></i18n:param>
	                    <i18n:param><span id="timer"></span></i18n:param>
	                </i18n:translate>
                </p>
                <script>
                    var timer = <xsl:value-of select="/LoginScreen/LoginForm/MultifactorAuthentication/@duration"/>, minutes, seconds;
                    var interval = setInterval(timing, 1000);
                    timing();
                    function timing() {
                        minutes = parseInt(timer / 60, 10);
                        seconds = parseInt(timer % 60, 10);
                
                        seconds = seconds &lt; 10 ? "0" + seconds : seconds;
                
                        document.getElementById("timer").innerHTML = minutes + ":" + seconds;
                
                        if (--timer &lt; 0) 
                        {
                            clearInterval(interval);
                            document.getElementById("mfa-back").click();
                        }                    
                    }
                </script>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="login-mfa-otpapp-intro">
        <div class="intro">
            <div class="textin">
                <p>
                    <i18n:translate>
                        <i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_TOTPAPP_INTRO" i18n:catalogue="plugin.core-ui"/>
                    </i18n:translate>
                </p>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="login-mfa-code">
        <div class="login-mfa-code">
             <xsl:if test="/LoginScreen/LoginForm/MultifactorAuthentication/@invalid = 'true'">
                 <div class="error">
                     <i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_INVALID_MFA_CODE" i18n:catalogue="plugin.core-ui"/>
                 </div>
             </xsl:if>
             
             <xsl:call-template name="login-mfa-code-input"/>
       </div>
    </xsl:template>
    
    <xsl:template name="login-mfa-code-input">
        <xsl:call-template name="login-mfa-code-input-wrapper">
            <xsl:with-param name="placeholder">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_PLACEHOLDER</xsl:with-param>
            <xsl:with-param name="hint">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_HINT</xsl:with-param>
            <xsl:with-param name="pattern-title">plugin.core-ui:PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_PATTERN_TITLE</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="login-mfa-code-input-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>
        <xsl:param name="pattern-title"/>
        
        <div class="login-input-wrapper login-input-wrapper-mfa-code login-input-wrapper-mfa-code-input">
            <xsl:call-template name="login-mfa-code-input-label-internal" />
            <div class="input">
                <input type="text" id="MultifactorAuthenticationCode" name="MultifactorAuthenticationCode" 
                        autofocus="true" required="required" autocomplete="one-time-code" maxlength="6" minlength="6">
                <script>
                    var onchange = function() {
                        if (this.selectionStart == this.maxLength &amp;&amp; document.activeElement == this)
                        { 
                            document.getElementById('MultifactorAuthenticationCodeSubmit').focus()
                        }
                    }
                    
                    var onfocus = function() {
                        if (this.selectionStart == this.maxLength)
                        {
                            this.value = "";
                        } 
                    }
                    
                    var multifactorAuthenticationCode = document.getElementById('MultifactorAuthenticationCode');
                    multifactorAuthenticationCode.onchange = onchange;
                    multifactorAuthenticationCode.onkeyup = onchange;
                    multifactorAuthenticationCode.onfocus = onfocus;
                </script>
<!--                     <xsl:if test="$placeholder != ''"> -->
<!--                         <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute> -->
<!--                         <xsl:attribute name="i18n:attr">placeholder</xsl:attribute> -->
<!--                     </xsl:if> -->
                    <xsl:if test="$pattern-title != ''">
                        <xsl:attribute name="title"><xsl:value-of select="$pattern-title"/></xsl:attribute>
                        <xsl:attribute name="i18n:attr">title<xsl:if test="$placeholder != ''"> placeholder</xsl:if></xsl:attribute>
                    </xsl:if>
                </input>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="login-mfa-code-input-label-internal">
        <div class="label">
            <label for="MultifactorAuthenticationCode"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_LABEL' i18n:catalogue='plugin.core-ui'/></label>
        </div>
    </xsl:template>
    
    <xsl:template name="login-mfa-otpapp-send-code">
        <div class="login-send-mfa-code">
            <a href="javascript:void(AmetysMFASendByEmail());"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_SEND_BY_MAIL_LABEL' i18n:catalogue='plugin.core-ui'/></a>
            <xsl:call-template name="login-mfa-send-email-script" />
        </div>
    </xsl:template>
    
    <xsl:template name="login-mfa-email-send-code">
	    <div class="login-send-mfa-code">
	        <a href="javascript:void(AmetysMFASendByEmail());"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_CODE_RESEND_BY_MAIL_LABEL' i18n:catalogue='plugin.core-ui'/></a>
	        <xsl:call-template name="login-mfa-send-email-script" />
	    </div>
    </xsl:template>
    
    <xsl:template name="login-mfa-send-email-script">
         <script>
            function AmetysMFASendByEmail()
            {
                document.getElementById('MultifactorAuthenticationMode').value = 'EMAIL'; 
                document.getElementById('MultifactorAuthenticationCode').disabled = true;
                document.getElementById('MultifactorAuthenticationCodeSubmit').click();
            }
         </script>
    </xsl:template>
    
    <xsl:template name="login-mfa-code-submit">
        <button type="submit" id="MultifactorAuthenticationCodeSubmit"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_VALIDATE_CODE' i18n:catalogue='plugin.core-ui'/></button>
    </xsl:template>
    
    <xsl:template name="login-mfa-back">
        <form method="post">
            <div class="login-inner login-back">
                <button type="submit" id="mfa-back"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_MFA_BACK' i18n:catalogue='plugin.core-ui'/></button>
            </div>
        </form>
    </xsl:template>
    
</xsl:stylesheet>
