<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                exclude-result-prefixes="ametys i18n">
    
    <xsl:import href="../common.xsl"/>
    <xsl:import href="login_form.xsl"/>
    
    <xsl:variable name="strongPasswordRequirements" select="/UserPassword/PasswordRequirements"/>
    
    <xsl:variable name="step" select="/UserPassword/@step"/>
    <xsl:variable name="status" select="/UserPassword/@status"/>
    
    <xsl:template name="css-file"><xsl:value-of select="ametys:workspaceThemeURL()"/>/sass/special/user-password.css</xsl:template>
    
    <xsl:template name="head"><i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_TITLE" i18n:catalogue="plugin.core-ui"/></xsl:template>
    
    <xsl:template name="head-more">
        <xsl:if test="$strongPasswordRequirements">
            <link rel="stylesheet" href="{$contextPath}/plugins/core-ui/resources/css/jquery.passwordRequirements.css"/>
            <script type="text/javascript" src="{$contextPath}/plugins/jquery-ametys/resources/js/jquery.js"></script>
            <script type="text/javascript" src="{$contextPath}/plugins/core-ui/resources/js/jquery.passwordRequirements.js"></script>
            
            <script type="text/javascript">
                $j = jQuery.noConflict();
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main">
        <xsl:call-template name="change-password-left-column"/>
        <xsl:call-template name="change-password-form-column"/>
        <xsl:call-template name="change-password-right-column"/>
    </xsl:template>
    
    <xsl:template name="change-password-form-column">
        <div class="wrapin login-form change-password">
            <xsl:call-template name="change-password-before"/>
            <xsl:call-template name="change-password"/>
            <xsl:call-template name="change-password-after"/>
        </div>
    </xsl:template>
    
    <xsl:template name="change-password-before">
        <h1><i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_TITLE" i18n:catalogue="plugin.core-ui"/></h1>
    </xsl:template>
    
    <xsl:template name="change-password">
        <div class="login">
            <div class="login-part">
                <xsl:choose>
                    <xsl:when test="$status = 'success'">
                        <xsl:call-template name="change-password-success-message"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Form to ask for reset or change password -->
                        <xsl:call-template name="change-password-form"/>
                    </xsl:otherwise>
                </xsl:choose>
            
                <!-- Back button -->
                <xsl:call-template name="change-password-back"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="change-password-success-message">
        <div class="intro">
            <div class="textin">
                <p>
                    <xsl:choose>
                        <xsl:when test="$step = 'reset-password'">
                            <i18n:text i18n:key="PLUGINS_CORE_UI_RESET_PASSWORD_SCREEN_REQUEST_SUCCESS" i18n:catalogue="plugin.core-ui"/>
                        </xsl:when>
                        <xsl:when test="$step = 'user-update'">
                            <i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_SUCCESS" i18n:catalogue="plugin.core-ui"/>
                        </xsl:when>
                    </xsl:choose>
                </p>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="change-password-form">
        <xsl:call-template name="change-password-intro"/>
        <xsl:call-template name="change-password-global-errors"/>
        <xsl:call-template name="change-password-errors"/>
        <form method="post">
            <xsl:call-template name="change-password-form-inner"/>
        </form>
    </xsl:template>
    
    <xsl:template name="change-password-intro">
        <div class="intro">
            <div class="textin">
                <p>
                    <xsl:choose>
                        <xsl:when test="$step = 'lost-password' or $step = 'reset-password'">
                            <i18n:text i18n:key="PLUGINS_CORE_UI_RESET_PASSWORD_SCREEN_REQUEST_INTRO" i18n:catalogue="plugin.core-ui"/>
                        </xsl:when>
                        <xsl:when test="$step = 'password' or $step = 'user-update'">
                            <xsl:choose>
                                <xsl:when test="/UserPassword/WeakPassword">
                                    <i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_INTRO_WEAK_PASSWORD" i18n:catalogue="plugin.core-ui"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_INTRO" i18n:catalogue="plugin.core-ui"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </p>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="change-password-global-errors">
        <xsl:if test="/UserPassword/errors/global">
            <div class="error">
                <ul>
                    <xsl:for-each select="/UserPassword/errors/global/error[@type]">
                        <li>
                            <i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_ERROR_{@type}" i18n:catalogue="plugin.core-ui"/>
                        </li>
                    </xsl:for-each>
                    <xsl:for-each select="/UserPassword/errors/global/error[not(@type)]">
                        <li>
                            <xsl:copy-of select="."/>
                        </li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="change-password-errors">
        <xsl:if test="count(/UserPassword/errors/field/error) > 0">
            <div class="error">
                <i18n:translate>
                    <i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_FORM_ERROR_TITLE" i18n:catalogue="plugin.core-ui"/>
                    <i18n:param><xsl:value-of select="count(/UserPassword/errors/field/error)"/></i18n:param>
                </i18n:translate>
                <ul>
                    <xsl:for-each select="/UserPassword/errors/field/error">
                        <li><xsl:copy-of select="*"/></li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="change-password-form-inner">
        <input type="hidden" name="contexts" value="{/UserPassword/@contexts}"/>
        <div class="login-inner login-form">
            <xsl:choose>
                <xsl:when test="$step = 'lost-password' or $step = 'reset-password'">
                    <xsl:call-template name="change-password-form-reset-inputs"/>
                </xsl:when>
                <xsl:when test="$step = 'password' or $step = 'user-update'">
                    <xsl:call-template name="change-password-form-update-inputs"/>
                </xsl:when>
            </xsl:choose>
            
            <xsl:call-template name="change-password-form-submit"/>
        </div>
    </xsl:template>
    
    
    <xsl:template name="change-password-form-reset-inputs">
        <xsl:if test="/UserPassword/UserPopulations/@size > 1">
            <xsl:call-template name="login-user-populations-part">
                <xsl:with-param name="populations" select="/UserPassword/UserPopulations"/>
            </xsl:call-template>
        </xsl:if>
        
        <xsl:call-template name="login-form-inputs-username"/>
    </xsl:template>
    
    <xsl:template name="change-password-form-update-inputs">
        <input type="hidden" name="token" value="{/UserPassword/token}"/>
        <!-- new password -->
        <xsl:call-template name="login-form-inputs-password-wrapper">
            <xsl:with-param name="id">Password</xsl:with-param>
            <xsl:with-param name="name">Password</xsl:with-param>
            <xsl:with-param name="placeholder">plugin.core-ui:PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_PASSWORD_PLACEHOLDER</xsl:with-param>
            <xsl:with-param name="hint">plugin.core-ui:PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_PASSWORD_HINT</xsl:with-param>
        </xsl:call-template>
        
        <xsl:apply-templates select="$strongPasswordRequirements" mode="field-js">
            <xsl:with-param name="passwordFieldId">Password</xsl:with-param>
        </xsl:apply-templates>
        
        <!-- confirm new -->
        <xsl:call-template name="login-form-inputs-password-wrapper">
            <xsl:with-param name="name">ConfirmPassword</xsl:with-param>
            <xsl:with-param name="id">ConfirmPassword</xsl:with-param>
            <xsl:with-param name="placeholder">plugin.core-ui:PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_CONFIRM_PLACEHOLDER</xsl:with-param>
            <xsl:with-param name="hint">plugin.core-ui:PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_CONFIRM_HINT</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="PasswordRequirements" mode="field-js">
        <xsl:param name="passwordFieldId">Password</xsl:param>
        
        <script type="text/javascript">
            var pr;
            $j(document).ready(function (){
                pr = $j("#<xsl:value-of select="$passwordFieldId"/>").passwordRequirements({
                    numCharacters: <xsl:value-of select="@minLength"/>,
                    minLowercase: <xsl:value-of select="@minLowercase"/>,
                    minUppercase: <xsl:value-of select="@minUppercase"/>,
                    minNumbers: <xsl:value-of select="@minNumbers"/>,
                    minSpecials: <xsl:value-of select="@minSpecials"/>,
                    specialCharacters: "<xsl:value-of select="@specialCharacters"/>"
                });
            });
            
        </script>
    </xsl:template>
    
    <xsl:template name="change-password-form-submit">
        <button type="submit">
            <i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_SUBMIT" i18n:catalogue="plugin.core-ui"/>
        </button>
    </xsl:template>
    
    <xsl:template name="change-password-back">
        <div class="login-inner login-back">
            <a href="{ametys:uriPrefix()}"><i18n:text i18n:key="PLUGINS_CORE_UI_CHANGE_PASSWORD_SCREEN_FORM_BACK" i18n:catalogue="plugin.core-ui"/></a>
        </div>
    </xsl:template>
    
    <!-- For override purposes -->
    <xsl:template name="change-password-after"/>
    <xsl:template name="change-password-left-column"/>
    <xsl:template name="change-password-right-column"/>
</xsl:stylesheet>